<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

return apply_filters(
	'wc_sunpay_setting',
	array(
		'enabled' => array(
			'title' => __('Enable/Disable','sunpay'),
			'type' => 'checkbox',
			'label' => __('Enable','sunpay'),
			'default' => 'no'
		),
		'test_mode' => array(
			'title' => __('Test Mode','sunpay'),
			'type' => 'checkbox',
			'label' => __('Enable','sunpay'),
			'default' => 'yes'
		),
		// 'title' => array(
		// 	'title' => __('Title','sunpay'),
		// 	'type' => 'text',
		// 	'description' => __('Payment method description that the customer will see on your checkout.', 'woocommerce'),
		// 	'default' => '紅陽金流',
		// 	'desc_tip' => true
		// ),
		'description' => array(
			'title' => __('Description','sunpay'),
			'type' => 'textarea',
			'description' => 'Payment method description that the customer will see on your website.',
			'default' => '透過 紅陽金流 付款',
			'desc_tip' => true
		),
		'web_value' => array(
			'title' => __('Merchant ID(web)','sunpay'),
			'type' => 'text',
			'description' => sprintf("請到<b>紅陽官網</b>登入特店專區(<a href='https://testmerchant.sunpay.com.tw/' target='_blank'>測試區</a>/<a href='https://merchant.sunpay.com.tw/' target='_blank'>正式區</a>)中查詢 <b>特店代號</b><br />紅陽結果通知網址：<b>%s</b>",
				network_site_url() . "/?wc-api=WC_sunpay&callback=return")
		),
		'web_rsa_public_key' => array(
			'title' => __('RSA Public Key','sunpay'),
			'type' => 'password',
			'description' => __('Sunpay RSA Public Key','sunpay'),
		),
		'web_sha2_key' => array(
			'title' => __('SHA2 Key','sunpay'),
			'type' => 'password',
			'description' => __('Sunpay SHA2 Key','sunpay'),
		),
		'checkout_button_text' => array(
			'title' => __('Checkout Button Text','sunpay'),
			'type' => 'text',
			'default' => __('Checkout', 'sunpay')
		),
		'SunpayPaymentMethodBuySafe'     => array(
			'title'   => __( 'Credit' ,'sunpay'),
			'type'    => 'checkbox',
			'label'   => __( 'Credit' ,'sunpay'),
			'default' => 'no',
		),
		'SunpayPaymentMethodbuysafemul'       => array(
			'title'   => __( 'Credit installment' ,'sunpay'),
			'type'    => 'checkbox',
			'label'   => __( 'Credit installment' ,'sunpay'),
			'default' => 'no',
		),
		// 'SunpayPaymentMethodGooglePay' => array(
		// 	'title'   => __( 'GooglePay' ,'sunpay'),
		// 	'type'    => 'checkbox',
		// 	'label'   => __( 'GooglePay' ,'sunpay'),
		// 	'default' => 'no',
		// ),
		// 'SunpayPaymentMethodApplePay' => array(
		// 	'title'   => __( 'ApplePay' ,'sunpay'),
		// 	'type'    => 'checkbox',
		// 	'label'   => __( 'ApplePay' ,'sunpay'),
		// 	'default' => 'no',
		// ),
		'SunpayPaymentMethodGooglePayAndApplePay' => array(
			'title'   => __( 'GooglePay/ApplePay' ,'sunpay'),
			'type'    => 'checkbox',
			'label'   => __( 'GooglePay/ApplePay' ,'sunpay'),
			'default' => 'no',
		),
		'SunpayPaymentMethodUnionPay'   => array(
			'title'   => __( 'UnionPay' ,'sunpay'),
			'type'    => 'checkbox',
			'label'   => __( 'UnionPay' ,'sunpay'),
			'default' => 'no',
		),
		// 'SunpayPaymentMethodWebATM'     => array(
		// 	'title'   => __( 'WebATM' ,'sunpay'),
		// 	'type'    => 'checkbox',
		// 	'label'   => __( 'WebATM' ,'sunpay'),
		// 	'default' => 'no',
		// ),
		'SunpayPaymentMethodAtm'       => array(
			'title'   => __( 'ATM' ,'sunpay'),
			'type'    => 'checkbox',
			'label'   => __( 'ATM' ,'sunpay'),
			'default' => 'no',
		),
		'SunpayPaymentMethod24Pay'        => array(
			'title'   => __( 'CVS Payment(Bill)' ,'sunpay'),
			'type'    => 'checkbox',
			'label'   => __( 'CVS Payment(Bill)' ,'sunpay'),
			'default' => 'no',
		),
		'SunpayPaymentMethodPayCode'    => array(
			'title'   => __( 'CVS Payment(PayCode)' ,'sunpay'),
			'type'    => 'checkbox',
			'label'   => __( 'CVS Payment(PayCode)' ,'sunpay'),
			'default' => 'no',
		),
		'SunpayPaymentMethodJkoPay'  => array(
			'title'   => __( 'JkoPay Payment' ,'sunpay'),
			'type'    => 'checkbox',
			'label'   => __( 'JkoPay Payment' ,'sunpay'),
			'default' => 'no',
		),
		'SunpayPaymentMethodSunShip'  => array(
			'title'   => __('SunShip','sunpay'),
			'type'    => 'checkbox',
			'label'   => __('SunShip','sunpay'),
			'default' => 'no',
		),
		'SunpayPaymentMethodSunShipWithPay' => array(
			'title'   => '超商取貨不付款',
			'type'    => 'checkbox',
			'label'   => '超商取貨不付款',
			'default' => 'no',
		),
		'eiEnable'                => array(
			'title'   => '紅陽電子發票',
			'type'    => 'checkbox',
			'label'   => '開立電子發票',
			'default' => 'no',
		),

		'eiCompanyID'        => array(
			'title'       => '紅陽電子發票 統一編號',
			'type'        => 'text',
			'description' => '請填入您的電子發票統一編號',
		),
		'eiMerchantID'        => array(
			'title'       => '紅陽電子發票 Merchant ID',
			'type'        => 'text',
			'description' => '請填入您的電子發票商店代號',
		),
		'eiHashKey'           => array(
			'title'       => '紅陽電子發票 Hash Key',
			'type'        => 'text',
			'description' => '請填入您的電子發票的HashKey',
		),
		'eiHashIV'            => array(
			'title'       => '紅陽電子發票 Hash IV',
			'type'        => 'text',
			'description' => '請填入您的電子發票的HashIV',
		),
		'eiIsSendMessage'              => array(
			'title'   => '發票簡訊通知',
			'type'    => 'select',
			'description' => '如需使用本服務，請確認是否啟用加值服務。若有疑問，請與業務窗口諮詢確認。',
			'options' => array(
				'0'   => '不需寄送簡訊通知',
				'1'   => '寄送發票簡訊通知',
			),
		),
		'eiIsSendPaper'              => array(
			'title'   => '紅陽代印發票',
			'type'    => 'select',
			'description' => '無載具時才會套用，如需使用本服務，請確認是否啟用加值服務。若有疑問，請與業務窗口諮詢確認。',
			'options' => array(
				'0'   => '不需代印',
				'1'   => '由紅陽代印發票',
			),
		),
		'eiTaxType'              => array(
			'title'   => '課稅別 ',
			'type'    => 'select',
			'options' => array(
				'1'   => '應稅',
				'2.1' => '零稅率-非經海關出口',
				'2.2' => '零稅率-經海關出口',
				'3'   => '免稅',
				'4'   => '應稅(特種)',
				// '9'   => '混合應稅與免稅或零稅率',
			),
		),
		'eiTaxRate'              => array(
			'title'   => '稅率 ',
			'type'    => 'text',
			'description' => '請帶入規定之稅率，例如：規定之稅率為18%，稅率請帶入【0.18】',
		),
	)
);
