<?php



if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class sunpayElectronicInvoice {

	private $sunpayTool;
	private $eiEnable;
    private $TestMode;
	private $companyID;
	private $merchantID;
	private $HashKey;
	private $HashIV;
	private $taxType;
	private $taxRate;
	private $IsSendMessage;
	private $IsSendPaper;

	private static $instance;

	/**
	 * Returns the *Singleton* instance of this class.
	 *
	 * @return Singleton The *Singleton* instance.
	 */
	public static function get_instance( $invData = array() ) {
		if ( null === self::$instance ) {
			self::$instance = new self( $invData );
		}
		return self::$instance;
	}

	protected function __construct( $invData = array() ) {
		$this->eiEnable      = $invData['eiEnable'];
		$this->companyID     = $invData['companyID'];
		$this->merchantID    = $invData['merchantID'];
		$this->HashKey       = $invData['HashKey'];
		$this->HashIV        = $invData['HashIV'];
		$this->IsSendMessage = intval($invData['IsSendMessage']);
		$this->IsSendPaper   = $invData['IsSendPaper'];
		$this->taxType       = intval($invData['taxType']);
		$this->taxRate       = $invData['taxRate'];
		$this->TestMode      = $invData['testMode'];

		$this->sunpayTool = sunpayTool::get_instance();

		add_action( 'woocommerce_after_checkout_form', array( $this, 'invoice_checkout' ) );
		add_action( 'woocommerce_after_order_notes', array( $this, 'sunpay_invoice_fields' ) );
		add_action( 'woocommerce_checkout_update_order_meta', array( $this, 'sunpay_invoice_fields_update_order_meta' ) );
	}

	function electronic_invoice( $order, $tradeNo ) {
		//固定使用台灣時間(UTC+8)
		date_default_timezone_set("Asia/Taipei");

		$CompanyID  = $this->companyID; // 商店統一編號
		$MerchantID = $this->merchantID; // 商店代號
		$key        = $this->HashKey;  // 商店專屬串接金鑰HashKey值
		$iv         = $this->HashIV;  // 商店專屬串接iv

		// $discount_with_no_tax = $order->get_total_discount();
		$discount_with_tax    = $order->get_total_discount( false );
		// 商品資訊
		$item_name = $order->get_items();
		$item_cnt  = 1;

		$buyerNeedUBN = $order->get_meta( '_billing_needUBN' );
		if ( $buyerNeedUBN ) {
			$buyerUBN    = $order->get_meta( '_billing_UBN' );
			$eiType    = 'B2B';
			$carrierType = intval($order->get_meta( '_billing_carrierType' ));
		} else {
			$buyerUBN    = '';
			$eiType    = 'B2C';
			$carrierType = intval($order->get_meta( '_billing_carrierType' ));
		}

		$productItems = array();
		foreach ( $item_name as $order_item_id => $item_value ) {
			// $pid 若取的到variation_id為可變商品 取到0為非可變商品
			$pid       = ( empty( $item_name[ $order_item_id ]->get_variation_id() ) ) ? $item_name[ $order_item_id ]->get_product_id() : $item_name[ $order_item_id ]->get_variation_id();
			$tax_class = $item_name[ $order_item_id ]->get_tax_class();
			$product = wc_get_product( $pid );
			@$rates_data = array_shift( WC_Tax::get_rates( $tax_class ) );
			$taxRate     = (float) $rates_data['rate']; // 取得稅率

			if ( ! $this->chkProductEiTypeisValid( $product, $eiType ) ) {
				$orderNote = '發票開立失敗<br>錯誤訊息：' . '無法取得商品資訊';
				$order->add_order_note( $orderNote );
				exit();
			}

			$productItems[] = array(
				"description" => $item_value->get_name(),
				"quantity" => $item_value->get_quantity(),
				"unit" => "個",
				"unitPrice" => $this->getProductPriceByEiType( $product, $eiType ),
				"amount" => $this->getProductPriceByEiType( $product, $eiType ) * $item_value->get_quantity(),
				"remark" => "",
				"taxType" => null,
			);			

			$item_cnt++;
		}

		if ( ! $this->chkOrderEiTypeisValid( $order, $eiType ) ) {
			$orderNote = '發票開立失敗<br>錯誤訊息：' . '無法取得訂單資訊';
			$order->add_order_note( $orderNote );
			exit();
		}

		if ( $order->get_total_shipping() > 0 ) {
			$productItems[] = array(
				"description" => $order->get_shipping_method(),
				"quantity" => "1",
				"unit" => "個",
				"unitPrice" => $this->getShippingPriceByEiType( $order, $eiType ),
				"amount" => $this->getShippingPriceByEiType( $order, $eiType ),
				"remark" => "",
				"taxType" => null,
			);			
		}

		if ( $discount_with_tax > 0 ) {
			$productItems[] = array(
				"description" => "折扣",
				"quantity" => "1",
				"unit" => "次",
				"unitPrice" => $discount_with_tax,
				"amount" => $discount_with_tax,
				"remark" => "",
				"taxType" => null,
			);			
		}

		$amt      = round( $order->get_total() ) - round( $order->get_total_tax() );
		$taxAmt   = round( $order->get_total_tax() );
		$totalAmt = round( $order->get_total() );

		$salesAmt = 0; //round($totalAmt / (1+$taxRate));
		$zeroAmt = 0;
		$freeAmt = 0;
		$customsClearanceMark = 0;
		$zeroTaxRateReason = null;
		$taxType          = $this->taxType;

		switch ( $taxType ) {
			case 1:
				$invoiceType = 7;
				$taxRate = 0.05;
				$salesAmt = round($totalAmt / (1+$taxRate));
				break;
			case 2.1:
				$taxType          = 2;
				$taxRate = 0;
				$invoiceType = 7;
				$customsClearanceMark = 1;
				$zeroAmt = round($totalAmt / (1+$taxRate));
				$zeroTaxRateReason = 71;
				break;
			case 2.2:
				$taxType          = 2;
				$taxRate = 0;
				$invoiceType = 7;
				$customsClearanceMark = 2;
				$zeroAmt = round($totalAmt / (1+$taxRate));
				$zeroTaxRateReason = 71;
				break;
			case 3:
				$invoiceType = 7;
				$taxRate = 0;
				$freeAmt = round($totalAmt / (1+$taxRate));
				break;
			case 4:
				$taxRate = $this->taxRate;
				$invoiceType = 8;
				$salesAmt = round($totalAmt / (1+$taxRate));
				break;
			case 9:
				$taxRate = null;
				$invoiceType = 7;
				$zeroTaxRateReason = 71;
				$salesAmt = round($totalAmt / (1+$taxRate));
				break;
		}

		// B2B可輸入買受人名稱 若無輸入就使用帳單的姓名(B2C直接用這個)
		$buyerName    = $order->get_meta( '_billing_Buyer' );
		$buyerName    = ( empty( $buyerName ) ) ? $order->get_billing_last_name() . ' ' . $order->get_billing_first_name() : $buyerName;
		$buyerEmail   = $order->get_billing_email();
		$buyerAddress = $order->get_billing_postcode() . $order->get_billing_state() . $order->get_billing_city() . $order->get_billing_address_1() . ' ' . $order->get_billing_address_2();
		$buyerPhone   = $order->get_billing_phone();

		$carrierId = $order->get_meta( '_billing_carrierId1' );

		switch ( $carrierType ) {
			case 0:
				//無載具
				$IsSendPaper = $this->IsSendPaper;
				// $carrierType = 0;
				$carrierId1  = null;
				$donateMark  = 0;
				$poban       = null;
				break;
			case 1:
				//手機條碼載具
				$IsSendPaper = 0;
				// $carrierType = 1;
				$carrierId1  = $carrierId;
				$donateMark  = 0;
				$poban       = null;
				break;
			case 2:
				//自然人憑證條碼載具
				$IsSendPaper = 0;
				// $carrierType = 2;
				$carrierId1  = $carrierId;
				$donateMark  = 0;
				$poban       = null;
				break;
			case 3:
				//紅陽會員載具
				$IsSendPaper = 0;
				// $carrierType = 3;
				$carrierId1  = null;
				$donateMark  = 0;
				$poban       = null;
				break;
			case 4:
				//捐贈發票
				$IsSendPaper = 0;
				$carrierType = 0;
				$carrierId1  = "";
				$donateMark  = 1;
				$poban       = $carrierId;
				break;
			default:
				//無載具
				$IsSendPaper = 0;
				$carrierType = 0;
				$carrierId1  = null;
				$donateMark  = 0;
				$poban       = null;
				break;
		}

		//API交易檢查碼
		$nowTimestamp = time();
		$tokenData = array(
			"CompanyID" => $CompanyID,
			// "TimeStamp" => strval($nowTimestamp),
			"TimeStamp" => strval(strtotime("+8 hours", $nowTimestamp)),
		);
		$tokenDataJson = json_encode($tokenData);
		$token = $this->sunpayTool->aesEncrypt(urlencode($tokenDataJson), $key, $iv);

		if($eiType == "B2B"){
			//B2B
			if ( $this->TestMode == 'yes' ) {
				$url = 'https://testinv.sunpay.com.tw/api/v1/SunPay/CreateInvoiceb2b'; // 測試網址
			} else {
				$url = 'https://einv.sunpay.com.tw/api/v1/SunPay/CreateInvoiceb2b'; // 正式網址
			}
			$post_data_array = array( // post_data欄位資料
				'merchantID'           => $MerchantID,
				'orderNo'              => $order->get_meta( '_sunpayMerchantOrderNo' ),
				'buyerIdentifier'      => $buyerUBN,
				'buyerName'            => $buyerName,
				'buyerEmailAddress'    => $buyerEmail,
				'IsSendMessage'        => $this->IsSendMessage,
				'buyerTelephoneNumber' => $buyerPhone,
				'IsSendPaper'          => $IsSendPaper,
				'buyerAddress'         => $buyerAddress,
				'invoiceType'          => $invoiceType,
				'taxType'              => $taxType,
				'taxRate'        	   => $taxRate,
				'taxAmount'            => $totalAmt - $salesAmt,
				'salesAmount' 		   => $salesAmt,
				'zeroTaxSalesAmount'   => $zeroAmt,
				'freeTaxSalesAmount'   => $freeAmt,
				'totalAmount'          => $totalAmt,
				'mem'         		   => "",
				'customsClearanceMark' => $customsClearanceMark,
				'zeroTaxRateReason'    => $zeroTaxRateReason,
				'productItems'         => $productItems,
				'Token'          	   => $token,
			);
		}else{
			//B2C
			if ( $this->TestMode == 'yes' ) {
				$url = 'https://testinv.sunpay.com.tw/api/v1/SunPay/CreateInvoiceb2c'; // 測試網址
			} else {
				$url = 'https://einv.sunpay.com.tw/api/v1/SunPay/CreateInvoiceb2c'; // 正式網址
			}
			$post_data_array = array( // post_data欄位資料
				'merchantID'           => $MerchantID,
				'orderNo'              => $tradeNo,
				'buyerIdentifier'      => "",
				'buyerName'            => $buyerName,
				'buyerEmailAddress'    => $buyerEmail,
				'isSendMessage'        => $this->IsSendMessage,
				'buyerTelephoneNumber' => $buyerPhone,
				'isSendPaper'          => $IsSendPaper,
				'buyerAddress'         => $buyerAddress,
				'invoiceType'          => $invoiceType,
				'donateMark'     	   => $donateMark ?? 0,
				'poban'       		   => $poban,
				'carrierType'      	   => $carrierType,
				'carrierId1'           => $carrierId1,
				'taxType'              => $taxType,
				'taxRate'        	   => $taxRate,
				'taxAmount'            => $totalAmt - $salesAmt,
				'salesAmount' 		   => $salesAmt,
				'zeroTaxSalesAmount'   => $zeroAmt,
				'freeTaxSalesAmount'   => $freeAmt,
				'totalAmount'          => $totalAmt,
				'mem'         		   => "",
				'customsClearanceMark' => $customsClearanceMark,
				'zeroTaxRateReason'    => $zeroTaxRateReason,
				'isprint'         	   => $IsSendPaper,
				'productItems'         => $productItems,
				'token'          	   => $token,
			);
		}

		$post_data_json              = json_encode($post_data_array); 
		$requestAry = array(
			'body'        => $post_data_json,
			'headers'     => [
				'Content-Type' => 'application/json',
			],
			'timeout'     => 60,
			'redirection' => 5,
			'blocking'    => true,
			'httpversion' => '1.0',
			'sslverify'   => true,
			'data_format' => 'body',
		);

		$result                 = wp_remote_post( $url, $requestAry ); // 背景送出
		// Add order notes on admin
		$respondDecode = json_decode( $result['body'] );
		if ( $respondDecode->status == "SUCCESS" ) {
			$resultDecode   = $respondDecode->result;
			$tradeNumber = $resultDecode->tradeNumber;
			$invoiceNumber  = $resultDecode->invoiceNumber;
			$orderNote      = $respondDecode->Message . '<br>紅陽開立序號: ' . $tradeNumber . '<br>' . '發票號碼: ' . $invoiceNumber;
		} else {
			$orderNote = '發票開立失敗<br>錯誤訊息：' . $respondDecode->errors[0];
		}
		$order->add_order_note( $orderNote );

		return $respondDecode;
	}


	private function chkOrderEiTypeisValid( $order, $eiType ) {
		if ( ! isset( $order ) ) {
			return false;
		}
		if ( ! isset( $eiType ) ) {
			return false;
		}
		return true;
	}

	private function chkProductEiTypeisValid( $product, $eiType ) {
		if ( ! isset( $product ) ) {
			return false;
		}
		if ( ! isset( $eiType ) ) {
			return false;
		}
		return true;
	}


	/**
	 * 依照發票類型取得單一產品價格
	 *
	 * @access public
	 * @param product $product , string $category
	 * @return float|boolean
	 */
	public function getProductPriceByEiType( $product, $eiType ) {
		switch ( $eiType ) {
			case 'B2B':
				return round( wc_get_price_including_tax( $product ), 2 );
				break;

			case 'B2C':
				return round( $product->get_price(), 2 ); // 含稅價
				break;
			default:
				return false;
				break;
		}
	}

	/**
	 * 依照發票類型取得運費價格
	 *
	 * @access public
	 * @param order $order , string $category
	 * @return float|boolean
	 */
	public function getShippingPriceByEiType( $order, $eiType ) {
		switch ( $eiType ) {
			case 'B2B':
				return round( $order->get_total_shipping() );
				break;

			case 'B2C':
				return round( $order->get_total_shipping() + $order->get_shipping_tax() ); // 含稅價
				break;
			default:
				return false;
				break;
		}
	}

	public function sunpay_invoice_fields( $checkout ) {
		$eiEnable = $this->eiEnable;
		if ( $eiEnable == 'yes' ) {
			echo "<div id='sunpay_invoice_fields'><h3>發票資訊</h3>";
			woocommerce_form_field(
				'billing_needUBN',
				array(
					'type'    => 'select',
					'label'   => '發票是否需要打統一編號',
					'options' => array(
						'0' => '否',
						'1' => '是',
					),
				),
				$checkout->get_value( 'billing_needUBN' )
			);

			echo "<div id='identifierDiv'>";
			woocommerce_form_field(
				'billing_UBN',
				array(
					'type'        => 'text',
					'label'       => '<div id="UBNdiv" style="display:inline;">統一編號</div><div id="UBNdivAlert" style="display:none;color:#FF0000;">&nbsp&nbsp格式錯誤!!!</div></p>',
					'placeholder' => '請輸入統一編號',
					'required'    => false,
					'default'     => '',
				),
				$checkout->get_value( 'billing_UBN' )
			);
			woocommerce_form_field(
				'billing_Buyer',
				array(
					'type'        => 'text',
					'label'       => '<div id="Buyerdiv" style="display:inline;">買受人名稱</div>',
					'placeholder' => '請輸入買受人名稱',
					'required'    => false,
					'default'     => '',
				),
				$checkout->get_value( 'billing_Buyer' )
			);
			echo '電子發票將寄送至您的電子郵件地址，請自行列印。</div>';

			echo "<div id='carrierTypeDiv'>";
			woocommerce_form_field(
				'billing_carrierType',
				array(
					'type'    => 'select',
					'label'   => '電子發票索取方式',
					'options' => array(
						'0'  => '無載具',
						'1'  => '手機條碼載具',
						'2'  => '自然人憑證條碼載具',
						'3'  => '紅陽會員載具',
						'4'  => '捐贈發票',
					),
				),
				$checkout->get_value( 'billing_carrierType' )
			);
			echo '</div>';

			echo "<div id='carrierIdDiv' style='display:none;'>";
			woocommerce_form_field(
				'billing_carrierId1',
				array(
					'type'        => 'text',
					'label'       => '<div id="carrierIdLabel">載具號碼</div>',
					'placeholder' => '電子發票通知將寄送至您的電子郵件地址',
					'required'    => false,
					'default'     => '',
				),
				$checkout->get_value( 'billing_carrierId1' )
			);
			echo '</div>';
			echo "<div id='carrierIdDivAlert' style='display:none;color:#FF0000;'>請輸入載具號碼</div>";
			echo '</div>';
		}
		return $checkout;
	}

	public function invoice_checkout() {
		// 引用js
		wp_enqueue_script(
			'sunpay_invoice_setting',
			plugins_url( 'assets/js/public/sunpayInvoiceSetting.js', dirname( dirname( __FILE__ ) ) ),
			array( 'jquery' )
		);
	}

	public function sunpay_invoice_fields_update_order_meta( $order_id ) {
		$order = wc_get_order( $order_id );
		if ( ! in_array( sanitize_text_field( $_POST['payment_method'] ), array( 'sunpay', 'spgateway' ) ) && $this->eiEnable == 'yes' ) {
			$orderNote = '此訂單尚未開立電子發票，如確認收款完成須開立發票，請至紅陽電子發票平台進行手動單筆開立。<br>發票資料如下<br>發票是否需要打統一編號： ';
			if ( sanitize_text_field( $_POST['billing_needUBN'] ) ) {
				$orderNote .= '是<br>';
				$orderNote .= '統一編號： ' . sanitize_text_field( $_POST['billing_UBN'] );
			} else {
				$carrierType    = sanitize_text_field( $_POST['billing_carrierType'] );
				$carrierId1 = sanitize_text_field( $_POST['billing_carrierId1'] );
				$orderNote     .= '否<br>電子發票索取方式： ';
				switch ( $carrierType ) {
					case 0:
						$orderNote .= '無載具';
						break;
					case 1:
						$orderNote .= '手機條碼載具 <br>載具號碼： ' . $carrierId1;
						break;
					case 2:
						$orderNote .= '自然人憑證條碼載具 <br>載具號碼： ' . $carrierId1;
						break;
					case 3:
						$carrierId1 = sanitize_text_field( $_POST['billing_email'] );
						$orderNote     .= '紅陽會員載具 <br>載具號碼： ' . $carrierId1;
						break;
					case 4:
						$orderNote .= '捐贈發票 <br>捐贈碼： ' . $carrierId1;
						break;
					default:
						$orderNote .= '紅陽會員載具 <br>載具號碼： ' . $carrierId1;
				}
			}
			$order->add_order_note( $orderNote );
		}

		// Hidden Custom Fields: keys starting with an "_".
		$order->update_meta_data( '_billing_needUBN', sanitize_text_field( $_POST['billing_needUBN'] ) );
		$order->update_meta_data( '_billing_UBN', sanitize_text_field( $_POST['billing_UBN'] ) );
		$order->update_meta_data( '_billing_carrierType', sanitize_text_field( $_POST['billing_carrierType'] ) );
		$order->update_meta_data( '_billing_carrierId1', sanitize_text_field( $_POST['billing_carrierId1'] ) );
		$order->update_meta_data( '_billing_Buyer', sanitize_text_field( $_POST['billing_Buyer'] ) );
		$order->save();
	}
}
