<?php


/**
 * Plugin Name: Sunpay Payment
 * Plugin URI: https://www.esafe.com.tw/
 * Description: SunPay Payment Gateway for WooCommerce - Allows payments by direct bank/wire transfer or BACS
 * Version: 1.0.0
 * Author: Sunpay
 * Author URI: https://www.sunpay.com.tw/developers/
 * License: GPLv2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.txt
 * WC requires at least: 6.4
 * WC tested up to: 6.8
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'SUNPAY_MAIN_PATH', dirname( __FILE__ ) );
define('WOOSUNPAY_PLUGIN_URL', plugin_dir_url(__FILE__));
define('WOOSUNPAY_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('WOOSUNPAY_PLUGIN_INCLUDE_DIR', WOOSUNPAY_PLUGIN_DIR . 'includes');

// To enable High-Performance Order Storage
add_action(
	'before_woocommerce_init',
	function() {
		if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
		}
	}
);

if ( ! class_exists( 'WC_Sunpay_Payment' ) ) {

	class WC_Sunpay_Payment {


		private static $instance;

		/**
		 * Returns the *Singleton* instance of this class.
		 *
		 * @return Singleton The *Singleton* instance.
		 */
		public static function get_instance() {
			if ( null === self::$instance ) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		protected function __construct() {
			add_action( 'plugins_loaded', array( $this, 'init' ) );
		}

		public function init() {
			$this->init_gateways();
		}

		private function init_gateways() {

            if ( ! class_exists( 'WC_Payment_Gateway' ) ) {
                return;
            }

			add_filter( 'woocommerce_payment_gateways', array( $this, 'add_sunpay_gateway' ) );

			$this->init_modules();
		}

		/**
		 * Add the gateway to WooCommerce
		 *
		 * @access public
		 * @param array $methods
		 * @package     WooCommerce/Classes/Payment
		 * @return array
		 */
		public function add_sunpay_gateway( $methods ) {
			$methods[] = 'WC_sunpay';
			return $methods;
		}

		private function init_modules() {
			include_once SUNPAY_MAIN_PATH . '/includes/sunpayenc/sunpayTool.php';
			include_once SUNPAY_MAIN_PATH . '/includes/sunpay/sunpayMPG.php';
			include_once SUNPAY_MAIN_PATH . '/includes/invoice/sunpayElectronicInvoice.php';
			include_once SUNPAY_MAIN_PATH . '/includes/api/sunpayOthersAPI.php';
		}
	}

	$GLOBALS['wc_sunpay_payment'] = WC_Sunpay_Payment::get_instance();

}
