<?php
date_default_timezone_set('Asia/Taipei');
include_once("../Tools/RsaUtils.php");
include_once("../Tools/CurlHandler.php");

use Tools\CurlHandler;
use Tools\RsaUtils;

//訂單編號
$orderNo = "TT" . time();
//商戶編號
$merchantId = "MC31793850";
//sha2密鑰
$sha2key = "D2AE96E5528531CFCDE90591695F973D23846ABD01A639AB1D3E0322D56E0ED9";
//[信用卡類]： 01 : 信用卡交易 (國內卡/國外卡)  02 : 銀聯卡交易 03 : Apple Pay/Google Pay 04 : Line Pay 05 : 台灣 Pay 06 : 四大超商代碼 07 : 四大超商條碼繳費08 : 虛擬帳號轉帳 10 : 街口支付
$card_type = "01";

//交易時間
$send_time = getSend_time();
//RSA公鑰
$public_key = "-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDGvZ1HnY+qEIF7HDwE5T+jO98vvgF8R7CNL0RG72kpO2eG2zNIMLAukEZszX+v9/FFgDwLkUtEeVoTt86cxcHEmi9nR/z7F38aMFJ8NtftaFd53uBga9hdD30G2CyX3RaCRCdt2ev4175z5a4w5dU//Rx7JfsnCHW/P82qvMtBsQIDAQAB
-----END PUBLIC KEY-----";
//RSA私鑰
$private_key = "-----BEGIN PRIVATE KEY-----
MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAMa9nUedj6oQgXscPATlP6M73y++AXxHsI0vREbvaSk7Z4bbM0gwsC6QRmzNf6/38UWAPAuRS0R5WhO3zpzFwcSaL2dH/PsXfxowUnw21+1oV3ne4GBr2F0PfQbYLJfdFoJEJ23Z6/jXvnPlrjDl1T/9HHsl+ycIdb8/zaq8y0GxAgMBAAECgYAx6vxvOX8VOzIahvv4StCSIn6rkjDzU1pgC+g9XPLv/VDCiZo23qvR9kEKIQ+aVk+Oomfyi9r45vYeD8PgkrdZRbsCXRKJtgZgLt1q8K4DQH4Ujk2v8T59GMTUhJTinvJXhAYhLQRH2wMZf0w5bfI94FhRnzlVWKUyQgUVbcux1QJBAPJQtiJbxJT1Szz0KhmLYKycbPdIpFmvjno9CSBzVk45q4sjqxLLI3xyCTCdNpO6jA3J3t9uErCtvzcFSNbghCcCQQDR9uue86Q0T5QtHm/BP3y4+QohZTfdfnIvYtalFhEV2pOYUIWgHfFYdAUF0PB1SbAdki/qv7UmZT874YnWWPpnAkBF8I3hdONUq0hAG6lbHiOVLsE0zr7BNC7HkX5k42VxxquAyZbDIeboMHH+miH6mcl64V121+qFHGEonFndy4fZAkEAleaIn8nocKRj8LZrKPevjsvWDLOb59lvoh8ZiXEwr36Go1bRn9fgx7rFHzrlgYcjYmlNJnbJ2Oit9Y12//40fwJARK2mk5PrjdCjZEEQm5BsNnYZxe4z5K8fAxKzTofAiA2PFqrcd7vX801jVqTBXjR7PBUJ+KqBW4zBX/UyBM2UlQ==
-----END PRIVATE KEY-----";

//head
$head['web'] = $merchantId;         //商戶編號
$head['send_time'] = $send_time;    //交易發起時間
//body
$body['td'] = $orderNo;
$body['country_type'] = "cht";
$body['mn'] = "200";

//將head和body串成json
$params['head'] = $head;
$params['body'] = $body;
print_r("送出資料 :\n" . json_encode($params, 320) . "\n");

//取得加密資料
$rsamsg = getRsamsg($params, $public_key);

//取得簽名
$check_value  = getCheck_value($params, $sha2key);

//$json = json_encode($params, 320); //不對網址和中文進行編碼
//print_r("加密資料 :" . $json . "\n");
//
//$RsaMsg = RsaUtils::rsa_encrypt($json, $public_key);
//print_r("公鑰加密 :" . $RsaMsg . "\n");
//
//$RsaMsg = RsaUtils::rsa_pri_decrypt($RsaMsg, $private_key);
//print_r("私鑰解密 :" . $RsaMsg . "\n");



//取得加密資料
function getRsamsg($params, $public_key)
{
    //將所有參數進行升序
    ksort($params);
    foreach ($params as $key => $value) {
        ksort($value);
        $params[$key] = $value;
    }
    //不對網址和中文進行編碼
    $json = json_encode($params, 320);
    //進行urlencode
    $url_encode = urlencode($json);
    //RSA公鑰加密
    return RsaUtils::rsa_encrypt($url_encode, $public_key);
}

//取得簽名
function getCheck_value($params, $sha2key)
{
    //將所有參數進行升序
    ksort($params);
    foreach ($params as $key => $value) {
        ksort($value);
        $params[$key] = $value;
    }
    //不對網址和中文進行編碼
    $json = json_encode($params, 320);
    //進行urlencode
    $url_encode = urlencode($json);

    return hash("sha256", $url_encode . $sha2key);
}

//取得交易時間
function getSend_time()
{
    //時間
    $d = new \DateTime();
    //毫秒計算，下面兩種方法任選一個
    $fff = floor($d->format('u') / 1000);
    $fff = substr(floor(microtime(true) * 1000), -3);
    $send_time = $fff . date("s") . date("i") . date("H") . date("Ymd");
    return $send_time;
}

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>測試交易</title>
    <!-- jquery-3.7.0 -->
    <script src="../resources/jquery/jquery-3.7.0.js"></script>

    <!-- bootstrap5 -->
    <link href="../resources/bootstrap-5.0.0-dist/css/bootstrap.css" rel="stylesheet">
    <script src="../resources/bootstrap-5.0.0-dist/js/bootstrap.js"></script>
</head>

<body>
    <form action="https://testtrade.sunpay.com.tw/v4/cash" method="post" target="_blank">
        <h1>訂單編號 : <?= $orderNo ?></h1>
        <table class="table">
            <thead>
                <tr>
                    <th>說明</th>
                    <th>參數</th>
                    <th>內容</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>紅陽提供之特店代號</td>
                    <td>web</td>
                    <td><input name="web" value="<?= $merchantId ?>"></td>
                </tr>
                <tr>
                    <td>交易發起時間</td>
                    <td>send_time</td>
                    <td><input name="send_time" value="<?= $send_time ?>"></td>
                </tr>
                <tr>
                    <td>加密資料</td>
                    <td>rsamsg</td>
                    <td><input name="rsamsg" value="<?= $rsamsg ?>"></td>
                </tr>
                <tr>
                    <td>簽名資料</td>
                    <td>check_value</td>
                    <td><input name="check_value" value="<?= $check_value ?>"></td>
                </tr>
            </tbody>
        </table>
        <button type="submit">送出</button>
    </form>
</body>

</html>