<?php
//API模式
date_default_timezone_set('Asia/Taipei');
include_once("Utils.php");
include_once("CurlHandler.php");

use core\tool\CurlHandler;
use Utils\Utils;

$d = new \DateTime();

//毫秒計算，下面兩種方法任選一個
$fff = floor($d->format('u') / 1000);
$fff = substr(floor(microtime(true) * 1000), -3);

//訂單編號
// $orderNo = "TT" . time();
$orderNo = "C230829170600470208";

//特店代號
$merchantId = "MC31793850";
//時間
// $tradetime = $fff . date("s") . date("i") . date("H") . date("d") . date("m") . date("Y");
$tradetime = $fff . date("s") . date("i") . date("H"). date("Ymd");

//網域
$Domin = "https://testtrade.sunpay.com.tw";
//sha2密鑰
$sha2key = "D2AE96E5528531CFCDE90591695F973D23846ABD01A639AB1D3E0322D56E0ED9";
//[信用卡類]： 
// 01 : 信用卡交易 (國內卡/國外卡) 
// 02 : 銀聯卡交易
// 03 : Apple Pay/Google Pay
// 04 : Line Pay
// 05 : 台灣 Pay
// 06 : 四大超商代碼
// 07 : 四大超商條碼繳費
// 08 : 虛擬帳號轉帳
$card_type="00";

//RSA公鑰
$public_key = "-----BEGIN PUBLIC KEY-----
MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDGvZ1HnY+qEIF7HDwE5T+jO98vvgF8R7CNL0RG72kpO2eG2zNIMLAukEZszX+v9/FFgDwLkUtEeVoTt86cxcHEmi9nR/z7F38aMFJ8NtftaFd53uBga9hdD30G2CyX3RaCRCdt2ev4175z5a4w5dU//Rx7JfsnCHW/P82qvMtBsQIDAQAB
-----END PUBLIC KEY-----";

//RSA私鑰
$private_key = "-----BEGIN PRIVATE KEY-----
MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAMa9nUedj6oQgXscPATlP6M73y++AXxHsI0vREbvaSk7Z4bbM0gwsC6QRmzNf6/38UWAPAuRS0R5WhO3zpzFwcSaL2dH/PsXfxowUnw21+1oV3ne4GBr2F0PfQbYLJfdFoJEJ23Z6/jXvnPlrjDl1T/9HHsl+ycIdb8/zaq8y0GxAgMBAAECgYAx6vxvOX8VOzIahvv4StCSIn6rkjDzU1pgC+g9XPLv/VDCiZo23qvR9kEKIQ+aVk+Oomfyi9r45vYeD8PgkrdZRbsCXRKJtgZgLt1q8K4DQH4Ujk2v8T59GMTUhJTinvJXhAYhLQRH2wMZf0w5bfI94FhRnzlVWKUyQgUVbcux1QJBAPJQtiJbxJT1Szz0KhmLYKycbPdIpFmvjno9CSBzVk45q4sjqxLLI3xyCTCdNpO6jA3J3t9uErCtvzcFSNbghCcCQQDR9uue86Q0T5QtHm/BP3y4+QohZTfdfnIvYtalFhEV2pOYUIWgHfFYdAUF0PB1SbAdki/qv7UmZT874YnWWPpnAkBF8I3hdONUq0hAG6lbHiOVLsE0zr7BNC7HkX5k42VxxquAyZbDIeboMHH+miH6mcl64V121+qFHGEonFndy4fZAkEAleaIn8nocKRj8LZrKPevjsvWDLOb59lvoh8ZiXEwr36Go1bRn9fgx7rFHzrlgYcjYmlNJnbJ2Oit9Y12//40fwJARK2mk5PrjdCjZEEQm5BsNnYZxe4z5K8fAxKzTofAiA2PFqrcd7vX801jVqTBXjR7PBUJ+KqBW4zBX/UyBM2UlQ==
-----END PRIVATE KEY-----";

//訂單查詢
checkorder($orderNo,$Domin, $merchantId, $tradetime, $public_key, $sha2key,$card_type);


//訂單查詢
function checkorder($orderNo, $Domin, $merchantId, $tradetime, $public_key, $sha2key,$card_type)
{
    print_r("訂單查詢 : <br>");
    // head
    $head['web']       = $merchantId; //特店代號
    $head['send_time']       = $tradetime;   //交易發起時間，格式為fffssmmHHddMMYYYY
    ksort($head); //進行升序

    // body
    $body['no']  = "01"; //
    $body['card_type']  = $card_type; //特店代號
    $body['td']     = $orderNo;  //特店訂單編號
    // $body['trade_no']     = "";  //紅陽交易編號

    //進行升序
    ksort($body);

    //將head和body串成json
    $params['body'][] = $body;
    $params['head'] = $head;
    $json = json_encode($params, 320); //不對網址和中文進行編碼
    print_r("加密前參數 : <br>" . $json . "<br>");

    $url_encode = urlencode($json);                         //進行urlencode
    // print_r("urlencode : <br>" . $url_encode . "<br>");

    $rsamsg = Utils::rsa_encrypt($url_encode, $public_key); //進行RSA分段加密
    print_r("簽名串明文 : <br>" . $url_encode . $sha2key . "<br>");

    $content = hash("sha256", $url_encode . $sha2key);

    $data['web'] = $merchantId;
    $data['send_time'] = $tradetime;
    $data['rsamsg'] = $rsamsg;
    $data['check_value'] = $content;

    $headers = array(
        'Content-Type: application/json',
        'Content-Length: ' . strlen(json_encode($data))
    );

    $url = $Domin . "/v4/query/PaymentCheck";
    $curl_result = CurlHandler::post($url, json_encode($data), $headers);

    print_r("送出地址 : <br>" . $url . "<br>");
    print_r("送出參數 : <br>" . json_encode($data) . "<br>");
    print_r("送出結果 : <br>" . $curl_result . "<br>");
}