<?php
/*
Sean Huber CURL library

This library is a basic implementation of CURL capabilities.
It works in most modern versions of IE and FF.

==================================== USAGE ====================================
It exports the CURL object globally, so set a callback with setCallback($func).
(Use setCallback(array('class_name', 'func_name')) to set a callback as a func
that lies within a different class)
Then use one of the CURL request methods:

get($url);
post($url, $vars); vars is a urlencoded string in query string format.

Your callback function will then be called with 1 argument, the response text.
If a callback is not defined, your request will return the response text.
*/
namespace Tools;

class CurlHandler {

    public static function doRequest($method, $url, $vars, $headers = array()) {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT ,20);
        curl_setopt($ch, CURLOPT_TIMEOUT, 25);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_USERAGENT, ' 	Mozilla/5.0 (Windows; U; Windows NT 5.1; zh-TW; rv:1.8.0.7) Gecko/20060909 Firefox/1.5.0.7');
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        if ($method == 'POST' && $vars != null) {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $vars);
        }
        if ($method == 'PUT') {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
            curl_setopt($ch, CURLOPT_POSTFIELDS, $vars);
        }
        if ($method == 'DELETE') {
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
            curl_setopt($ch, CURLOPT_POSTFIELDS, $vars);
        }

        $data = curl_exec($ch);

        //api是否域名不通發生warning
        set_error_handler(function($errno, $errstr, $errfile, $errline){
            throw new \ErrorException($errstr, $errno, 0, $errfile, $errline);
        });

        if (!$data) {
            $data = curl_error($ch);
        }

        curl_close($ch);

        return $data;
    }

    //回傳api域名不通的錯誤
    private static function apiUrlException($error,$url)
    {
        $obj = ReturnHandler::responseObj(299);
        $obj['error'] = $error;
        $obj['apiUrl'] = $url;
        $errorJsonStr = Json::encode($obj);
        return PtEncryption::encrypt(SystemConfig::$pesKey, $errorJsonStr);
    }

    public static function get($url, $headers = array())
    {
        try {
            $result = self::doRequest('GET', $url, null, $headers);
        } catch (\ErrorException $e) {
            $error = $e->getMessage();
        }
        
        if(isset($error)){
            $result = self::apiUrlException($error,$url);
        }

        return $result;
        
    }

    public static function post($url, $vars, $headers = array())
    {
        try {
            $result = self::doRequest('POST', $url, $vars, $headers);
        } catch (\ErrorException $e) {
            $error = 1;
        }

        if(isset($error)){
            $result = self::apiUrlException($error,$url);
        }

        return $result;
    }

    public static function put($url, $vars, $headers = array())
    {
        try {
            $result = self::doRequest('PUT', $url, $vars, $headers);
        } catch (\ErrorException $e) {
            $error = 1;
        }

        if(isset($error)){
            $result = self::apiUrlException($error,$url);
        }

        return $result;
    }

    public static function delete($url, $vars, $headers = array())
    {
        try {
            $result = self::doRequest('DELETE', $url, $vars, $headers);
        } catch (\ErrorException $e) {
            $error = 1;
        }

        if(isset($error)){
            $result = self::apiUrlException($error,$url);
        }

        return $result;
    }

}
