<?php

namespace Opencart\Admin\Controller\Extension\SunpayPayment\Payment;

/**
 * @author HughesWu extend Roger
 * @author Stally
 */
class SunpayPayment extends \Opencart\System\Engine\Controller
{
	/**
	 * DB Prefix
	 */
	private $paymentSubfix = 'payment_sunpay_payment';

	/**
	 * test2
	 */
	private $error = array();

	private $version = '1.0.0';

	public function index()
	{
		$this->init();
		//post
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->edit_data();
		}

		$data = $this->get_output();

		$this->response->setOutput($this->load->view('extension/sunpay_payment/payment/sunpay_payment', $data));
	}

	private function init()
	{
		$this->load->language('extension/sunpay_payment/payment/sunpay_payment');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('setting/setting');
		$this->load->model('localisation/language');
		$this->load->model('localisation/geo_zone');
		$this->load->model('localisation/order_status');
		$this->document->setTitle($this->language->get('heading_title'));
	}

	private function edit_data()
	{
		$this->request->post[$this->paymentSubfix . '_paytype'] = html_entity_decode($this->request->post[$this->paymentSubfix . '_paytype']);
		$this->model_setting_setting->editSetting($this->paymentSubfix, $this->request->post);
		$this->session->data['success'] = $this->language->get('text_success');
		$this->response->redirect($this->url->link('extension/sunpay_payment/payment/sunpay_payment', 'user_token=' . $this->session->data['user_token'], 'SSL'));
	}

	private function get_output()
	{
		$data['languages'] = $this->model_localisation_language->getLanguages();
		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		$data['heading_title'] = $this->language->get('heading_title');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_all_zones'] = $this->language->get('text_all_zones');
		$data['entry_subfix'] = $this->paymentSubfix;
		//error_bank 改為 error_heading_title 20150303
		$data['entry_heading_title'] = $this->language->get('heading_title');
		$data['entry_test_mode'] = $this->language->get('entry_test_mode');
		$data['entry_test_fix'] = $this->language->get('entry_test_fix');
		$data['entry_merchant_id'] = $this->language->get('entry_merchant_id');
		$data['entry_description'] = $this->language->get('entry_description');
		$data['entry_rsa_key'] = $this->language->get('entry_rsa_key');
		$data['entry_sha2_key'] = $this->language->get('entry_sha2_key');
		// $data['entry_item_desc'] = $this->language->get('entry_item_desc');
		// $data['entry_item_desc_content'] = $this->language->get('entry_item_desc_content');
		$data['entry_order_status'] = $this->language->get('entry_order_status');
		$data['entry_order_finish_status'] = $this->language->get('entry_order_finish_status');
		$data['entry_order_fail_status'] = $this->language->get('entry_order_fail_status');
		$data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');
		$data['tab_general'] = $this->language->get('tab_general');
		$data['payment_method'] = $this->language->get('payment_method');
		$data['payment_method_list'] = $this->get_method_list();


		//invoice
		$data['entry_inv_status'] = $this->language->get('entry_inv_status');
		$data['entry_inv_company_id'] = $this->language->get('entry_inv_company_id');
		$data['entry_inv_merchant_id'] = $this->language->get('entry_inv_merchant_id');
		$data['entry_inv_hash_key'] = $this->language->get('entry_inv_hash_key');
		$data['entry_inv_hash_iv'] = $this->language->get('entry_inv_hash_iv');
		$data['entry_inv_is_send_message'] = $this->language->get('entry_inv_is_send_message');
		$data['entry_inv_is_send_page'] = $this->language->get('entry_inv_is_send_page');
		$data['entry_inv_tax_type'] = $this->language->get('entry_inv_tax_type');
		$data['tax_type'] = [
			[
				'type' => '1',
				'desc' => '應稅'
			],
			[
				'type' => '2.1',
				'desc' => '零稅率-非經海關出口'
			],
			[
				'type' => '2.2',
				'desc' => '零稅率-經海關出口'
			],
			[
				'type' => '3',
				'desc' => '免稅'
			],
			[
				'type' => '4',
				'desc' => '應稅(特種)'
			]
		];
		$data['entry_inv_tax_rate'] = $this->language->get('entry_inv_tax_rate');

		//error
		$data['error_warning'] = (isset($this->error['warning'])) ? $this->error['warning'] : '';
		$data['error_warning2'] = (isset($this->error['warning2'])) ? $this->error['warning2'] : '';
		$data['error_warning3'] = (isset($this->error['warning3'])) ? $this->error['warning3'] : '';
		$data['error_warning4'] = (isset($this->error['warning4'])) ? $this->error['warning4'] : '';
		$data['error_warning5'] = (isset($this->error['warning5'])) ? $this->error['warning5'] : '';

		//error_bank 改為 error_heading_title 20150303
		$data['error_heading_title'] = (isset($this->error['heading_title'])) ? $this->error['heading_title'] : '';

		$data['breadcrumbs'] = array();
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL'),
			'separator' => false
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', 'SSL'),
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/sunpay_payment/payment/sunpay_payment', 'user_token=' . $this->session->data['user_token'], 'SSL'),
			'separator' => ' :: '
		);

		$data['action'] = $this->url->link('extension/sunpay_payment/payment/sunpay_payment', 'user_token=' . $this->session->data['user_token'], 'SSL');
		$data['back'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', 'SSL');

		$data['text_info'] = sprintf($this->language->get('text_info'), $this->version);

		$data['return_url'] = str_replace("admin/", "", $this->url->link('extension/sunpay_payment/payment/sunpay_payment.feedback', '', 'SSL'));
		$data['redirect_url'] = str_replace("admin/", "", $this->url->link('extension/sunpay_payment/payment/sunpay_payment.feedbackShow', '', 'SSL'));

		// setting
		$settings = array(
			'order_status_id',
			'order_finish_status_id',
			'order_fail_status_id',
			'geo_zone_id',
			'status',
			'sort_order',
			'test_mode',
			'test_fix',
			'merchant_id',
			'rsa_key',
			'sha2_key',
			'item_desc',
			//invoice
			'inv_status',
			'inv_company_id',
			'inv_merchant_id',
			'inv_hash_key',
			'inv_hash_iv',
			'inv_is_send_message',
			'inv_is_send_page',
			'inv_tax_type',
			'inv_tax_rate',
		);

		foreach ($settings as $name) {
			$variable_name = "{$this->paymentSubfix}_{$name}";
			if (isset($this->request->post[$variable_name])) {
				$data[$name] = $this->request->post[$variable_name];
			} else {
				$data[$name] = $this->config->get($variable_name);
			}
		}

		$data['header'] = $this->load->controller('common/header');

		$data['column_left'] = $this->load->controller('common/column_left');

		$data['footer'] = $this->load->controller('common/footer');

		//固定語言檔 20150303
		// $data['payment_description'] = (isset($this->request->post[$this->paymentSubfix . '_description'])) ? $this->request->post[$this->paymentSubfix . '_description'] : $this->config->get($this->paymentSubfix . '_description');


		return $data;
	}

	private function get_method_list()
	{
		$output_data = [];

        $payment_method = [
            'BuySafe',
            'buysafemul',
            'GooglePayAndApplePay',
            'UnionPay',
            'Atm',
            '24Pay',
            'PayCode',
            'JkoPay',
            'SunShip',
			'SunShipWithPay',
        ];

		foreach ($payment_method as $row) {
			$output_data[] = [
				'name' => $this->language->get($row),
				'key' => $row,
				'payment_check' => (isset($this->request->post["{$this->paymentSubfix}_method_{$row}"])) ? $this->request->post["{$this->paymentSubfix}_method_{$row}"] : $this->config->get("{$this->paymentSubfix}_method_{$row}")
			];
		}

		return $output_data;
	}

	protected function validate()
	{

		if (!$this->user->hasPermission('modify', 'extension/sunpay_payment/payment/sunpay_payment')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post[$this->paymentSubfix . '_merchant_id']) {
			$this->error['warning2'] = $this->language->get('error_merchant_id');
		}

		if (!$this->request->post[$this->paymentSubfix . '_rsa_key']) {
			$this->error['warning3'] = $this->language->get('error_rsa_key');
		}

		if (!$this->request->post[$this->paymentSubfix . '_sha2_key']) {
			$this->error['warning4'] = $this->language->get('error_sha2_key');
		}

		// if (!$this->request->post[$this->paymentSubfix . '_item_desc']) {
		// 	$this->error['warning5'] = $this->language->get('error_item_desc');
		// } else if (mb_strlen($this->request->post[$this->paymentSubfix . '_item_desc']) > 50) {
		// 	$this->error['warning5'] = $this->language->get('error_item_desc_length');
		// } else if (!preg_match("/^[\x80-\xff_a-zA-Z0-9,_ ]+$/", $this->request->post[$this->paymentSubfix . '_item_desc'])) {
		// 	$this->error['warning5'] = $this->language->get('error_item_desc_content');
		// }

		return !$this->error;
	}

	public function createInvoiceNo()
	{
		$this->load->language('sale/order');

		$json = array();

		if (!$this->user->hasPermission('modify', 'sale/order')) {
			$json['error'] = $this->language->get('error_permission');
		} elseif (isset($this->request->get['order_id'])) {
			if (isset($this->request->get['order_id'])) {
				$order_id = $this->request->get['order_id'];
			} else {
				$order_id = 0;
			}

			$this->load->model('sale/order');

			// check inv status
			$inv_status = $this->config->get($this->paymentSubfix . '_inv_status');

			if ($inv_status == 1) {

				//inv setting
				$inv_settings = [
					'inv_merchant_id' => $this->config->get($this->paymentSubfix . '_inv_merchant_id'),
					'inv_hash_key' => $this->config->get($this->paymentSubfix . '_inv_hash_key'),
					'inv_hash_iv' => $this->config->get($this->paymentSubfix . '_inv_hash_iv'),
					'inv_create_type' => $this->config->get($this->paymentSubfix . '_inv_create_type'),
				];

				foreach ($inv_settings as $row => $value) {
					if ($value == '') {
						$err_msg = '發票欄位值不得為空:' . $row;
					}
				}

				//orders
				$order = $this->model_sale_order->getOrder($order_id);
				$products  		= $this->model_sale_order->getOrderProducts($order_id);		// 訂購商品
				$itemName = $this->getItemDescByProduct($products);
				$itemCount = $this->getItemTotalCount($products);
				$itemPrice = $this->getItemPrice($products);
				$TotalAmt = $this->getTotalAmount($products);
				$itemUnit = $this->getItemUnit($products);
				$itemAmt = $this->getItemAmount($products);

				//inv
				$inv_data = $this->db->query("SELECT * FROM " . DB_PREFIX . "inv_data WHERE order_id = '" . (int)$order_id . "'");
				$inv_data = $inv_data->row;
				$test_mode = $this->config->get($this->paymentSubfix . '_test_mode');
				if ($test_mode == 1) {
					$url = 'https://cinv.ezpay.com.tw/API/invoice_issue'; // 測試網址
				} else {
					$url = 'https://inv.ezpay.com.tw/API/invoice_issue'; // 正式網址
				}

				$loveCode = '';

				switch ($inv_data['CARRIER_TYPE']) {
					case '0':
						$carruerType = '0';
						$carruerNum = $inv_data['CARRIER_NUM'];
						$printFlag = 'N';
						break;
					case '1':
						$carruerType = '1';
						$carruerNum = $inv_data['CARRIER_NUM'];
						$printFlag = 'N';
						break;
					case '2':
						$carruerType = '2';
						$carruerNum = $order_id . $order['email'];
						$printFlag = 'N';
						break;

					case '3':
						$carruerType = '';
						$carruerNum = '';
						$loveCode = $inv_data['CARRIER_NUM'];
						$printFlag = 'N';
						break;
					case '-1':
						$carruerType = '';
						$carruerNum = '';
						$printFlag = 'Y';
						break;
				}

				$amt = $TotalAmt * 0.95;
				$taxAmt = $TotalAmt * 0.05;

				$post_data_array = array( // post_data欄位資料
					'RespondType'      => 'JSON',
					'Version'          => '1.5',
					'TimeStamp'        => time(),
					'MerchantOrderNo'  => $order_id,
					'Status'           => $inv_settings['inv_create_type'] == '2' ? '3' : '1',
					'CreateStatusTime' => $inv_settings['inv_create_type'] == '2' ? date('Ymd', strtotime("+1 days", time())) : '',
					'Category'         => ($inv_data['INV_UBN'] != '' && $inv_data['INV_UBN'] != '0') ? 'B2B' : 'B2C',
					'BuyerName'        => $order['firstname'] . ' ' . $order['lastname'],
					'BuyerUBN'         => ($inv_data['INV_UBN'] != '' && $inv_data['INV_UBN'] != '0') ? $inv_data['INV_UBN'] : '',
					'BuyerAddress'     => $order['payment_country'] . $order['payment_postcode'] . $order['payment_city'] . $order['payment_address_1'] . $order['payment_address_2'],
					'BuyerEmail'       => $order['email'],
					'CarrierType'      => $carruerType,
					'CarrierNum'       => $carruerNum,
					'LoveCode'         => $loveCode,
					'PrintFlag'        => $printFlag,
					'TaxType'          => '1',
					'TaxRate'          => '5',
					'Amt'              => round($amt),
					'TaxAmt'           => round($taxAmt),
					'TotalAmt'         => round($TotalAmt),
					'ItemName'         => $itemName,
					'ItemCount'        => $itemCount,
					'ItemUnit'         => $itemUnit,
					'ItemPrice'        => $itemPrice,
					'ItemAmt'          => $itemAmt,
				);

				$inv_mer_id = $this->config->get($this->paymentSubfix . '_inv_merchant_id');
				$inv_key = $this->config->get($this->paymentSubfix . '_inv_hash_key');
				$inv_iv = $this->config->get($this->paymentSubfix . '_inv_hash_iv');

				$post_data              = $this->create_mpg_aes_encrypt($post_data_array, $inv_key, $inv_iv);

				$invoice_post = array( // 送出欄位
					'MerchantID_' => $inv_mer_id,
					'PostData_'   => $post_data,
					'CartVersion' => 'New_openCart_1_0_0',
				);

				$invoice_result = $this->_curl($url, http_build_query($invoice_post), 'POST');

				$result_arr = json_decode($invoice_result['web_info'], true);

				if ($result_arr['Status'] == 'SUCCESS') {
					$result_arr['Result'] = json_decode($result_arr['Result'], true);
					$trans_no = $result_arr['Result']['InvoiceTransNo'];
					$inv_no = $result_arr['Result']['InvoiceNumber'];

					$inv_prefix 	= substr($inv_no, 0, 2);

					$inv_trans_info		= '紅陽電子發票交易序號:' . $trans_no;

					$this->db->query("UPDATE `" . DB_PREFIX . "order` SET invoice_no = '" . $inv_no . "', invoice_prefix = '" . $this->db->escape($inv_prefix) . "' WHERE order_id = '" . (int)$order_id . "'");
					$this->db->query("INSERT INTO " . DB_PREFIX . "order_history SET order_id = '" . (int)$order_id . "', order_status_id = '" . (int)$order['order_status_id'] . "', notify = '0', comment = '" . $this->db->escape($inv_trans_info) . "', date_added = NOW()");

					return $inv_no;
				} else {
					$inv_trans_info = "紅陽電子發票開立失敗，錯誤代碼:{$result_arr['Status']}，訊息:{$result_arr['Message']}";

					$this->db->query("INSERT INTO " . DB_PREFIX . "order_history SET order_id = '" . (int)$order_id . "', order_status_id = '" . (int)$order['order_status_id'] . "', notify = '0', comment = '" . $this->db->escape($inv_trans_info) . "', date_added = NOW()");
				}
			}
		}
	}

	private function getItemDescByProduct($products)
	{
		if (!isset($products)) return $this->config->get('payment_sunpay_payment_item_desc');
		$item_desc = '';
		foreach ($products as $_ind => $product) {
			if (($_ind + 1) == count($products)) {
				$item_desc .= $product['name'];
				break;
			}
			$item_desc .= $product['name'] . '|';
		}
		if (strlen($item_desc) > 50) return $this->config->get('payment_sunpay_payment_item_desc');
		return $item_desc;
	}

	private function getItemTotalCount($products)
	{
		$item_count = '';
		foreach ($products as $_ind => $product) {
			if (($_ind + 1) == count($products)) {
				$item_count .= $product['quantity'];
				break;
			}
			$item_count .= $product['quantity'] . '|';
		}

		return $item_count;
	}

	private function getItemPrice($products)
	{
		$item_price = '';
		foreach ($products as $_ind => $product) {
			if (($_ind + 1) == count($products)) {
				$item_price .= ceil($product['price']);
				break;
			}
			$item_price .= ceil($product['price']) .  '|';
		}

		return $item_price;
	}

	private function getTotalAmount($products)
	{
		$totalPrice = 0;
		foreach ($products as $_ind => $product) {
			if (($_ind + 1) == count($products)) {
				$totalPrice += ceil($product['price']);
				break;
			}
			$totalPrice += ceil($product['price']);
		}

		return $totalPrice;
	}

	private function getItemUnit($products)
	{
		$item_unit = '';
		foreach ($products as $_ind => $product) {
			if (($_ind + 1) == count($products)) {
				$item_unit .= '個';
				break;
			}
			$item_unit .= '個' .  '|';
		}

		return $item_unit;
	}

	private function getItemAmount($products)
	{
		$item_amt = '';
		foreach ($products as $_ind => $product) {
			if (($_ind + 1) == count($products)) {
				$item_amt .= ceil($product['price']) * $product['quantity'];
				break;
			}
			$item_amt .= ceil($product['price']) * $product['quantity'] .  '|';
		}


		return $item_amt;
	}

	private function create_mpg_aes_encrypt($parameter, $key = "", $iv = "")
	{
		$return_str = '';
		if (!empty($parameter)) {
			ksort($parameter);
			$return_str = http_build_query($parameter);
		}
		return trim(bin2hex(openssl_encrypt($this->addpadding($return_str), 'aes-256-cbc', $key, OPENSSL_RAW_DATA | OPENSSL_ZERO_PADDING, $iv)));
	}

	private function addpadding($string, $blocksize = 32)
	{
		$len = strlen($string);
		$pad = $blocksize - ($len % $blocksize);
		$string .= str_repeat(chr($pad), $pad);
		return $string;
	}

	function _curl($url = '', $parameter = '', $post_type = '')
	{
		$curl_options = array(
			CURLOPT_URL => $url,
			CURLOPT_HEADER => false,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_USERAGENT => $this->request->server['HTTP_USER_AGENT'],
			CURLOPT_SSL_VERIFYPEER => FALSE,
			CURLOPT_SSL_VERIFYHOST => FALSE,
			CURLOPT_IPRESOLVE => CURL_IPRESOLVE_V4,
		);

		if ($post_type == 'POST') {
			$curl_options[CURLOPT_POST] = "1";
			$curl_options[CURLOPT_POSTFIELDS] = $parameter;
		}

		$ch = curl_init();
		curl_setopt_array($ch, $curl_options);
		$result = curl_exec($ch);
		$retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		$curl_error = curl_errno($ch);

		curl_close($ch);

		$return_info = array(
			"url" => $url,
			"sent_parameter" => $parameter,
			"http_status" => $retcode,
			"curl_error_no" => $curl_error,
			"web_info" => $result,
		);

		return $return_info;
	}

	// install
	public function install()
	{
		$this->load->model('setting/event');

		$eventData = array(
			'code'       => 'sunpay_create_invoice',
			'description' => '',
			'trigger'    => 'admin/model/sale/order/createInvoiceNo/before',
			'action'     => 'extension/payment/sunpay_payment/createInvoiceNo',
			'status'     => '',
			'sort_order' => '',
		);

		$this->model_setting_event->addEvent($eventData);
		$this->db->query("
			CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "inv_data` (
			  `INV_SYS_ID` INT(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
			  `ORDER_ID` INT(11) NOT NULL,
			  `INV_UBN` INT(10),
			  `INV_UBN_BUYER` VARCHAR(20),
			  `CARRIER_TYPE` VARCHAR(2) ,
			  `CARRIER_NUM` VARCHAR(20) ,
			  `CREATETIME` DATETIME
			) DEFAULT COLLATE=utf8_general_ci;");
	}

	// uninstall
	public function uninstall()
	{
		$this->load->model('setting/setting');
		$this->load->model('setting/extension');

		$this->model_setting_extension->uninstall('sunpay_create_invoice', $this->request->get['extension']);
		$this->model_setting_setting->deleteSetting($this->request->get['extension']);
		$this->model_setting_event->deleteEventByCode('sunpay_create_invoice');

		$this->db->query("DROP TABLE IF EXISTS `" . DB_PREFIX . "inv_data`;");
	}
}
