<?php
namespace Opencart\Catalog\Model\Extension\SunpayPayment\Payment;
/**
 * @author HughesWu extend Roger
 */
class SunpayPayment extends \Opencart\System\Engine\Model
{

	public function __construct($registry)
	{
		parent::__construct($registry);
	}

	public function getMethods(array $address): array
	{

		$this->load->language('extension/sunpay_payment/payment/SunpayMPG');

		$country_id = 0;
		$zone_id    = 0;
		if ($this->cart->hasShipping()) {
			if (isset($address['country_id'])) {
				$country_id = $address['country_id'];
			} elseif (isset($this->session->data['shipping_address']['country_id'])) {
				$country_id = $this->session->data['shipping_address']['country_id'];
			}
			if (isset($address['zone_id'])) {
				$zone_id = $address['zone_id'];
			} elseif (isset($this->session->data['shipping_address']['zone_id'])) {
				$zone_id = $this->session->data['shipping_address']['zone_id'];
			}
		}

		$sql  = "SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE";
		$sql .= " geo_zone_id = '" . (int)$this->config->get('payment_sunpay_payment_geo_zone_id') . "'";
		$sql .= " AND country_id = '" . (int)$country_id . "'";
		$sql .= " AND (zone_id = '" . (int)$zone_id . "' OR zone_id = '0')";

		$query = $this->db->query($sql);

		$status = true;

		if (!$this->config->get('payment_sunpay_payment_geo_zone_id')) {
			$status = true;
		} elseif ($query->num_rows) {
			$status = true;
		} else {
			$status = false;
		}

		$method_data = array();

		if ($status) {

			$option_data['sunpay_payment'] = [
				'code' => 'sunpay_payment.sunpay_payment',
				'name' => $this->language->get('text_title')
			];

			$method_data = array(
				'code'       => 'sunpay_payment',
				'name'      => $this->language->get('text_title'),
				'title'      => $this->language->get('text_title'),
				'option'	 => $option_data,
				'sort_order' => $this->config->get('payment_sunpay_payment_sort_order')
			);

			$method_data["title"] .= "  (" . $this->config->get('payment_sunpay_payment_description') . ")";


			/*
			if (in_array($language, array("zh-TW", "en"))) {
			
				if ($language == "en"  && !empty($this->config->get('SunpayMPG_description_1'))) { 
					$method_data["title"] .= "  (" . $this->config->get('SunpayMPG_description_1') . ")";
				}
			
				if ($language == "zh-TW"  && !empty($this->config->get('SunpayMPG_description_2'))) {
					$method_data["title"] .= "  (" . $this->config->get('SunpayMPG_description_2') . ")";
				}
			}
			*/
		}

		return $method_data;
	}
}
?>
