/**
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
/*browser:true*/
/*global define*/
define(
    [
        'Magento_Checkout/js/view/payment/default',
        'Magento_Checkout/js/model/payment/additional-validators',
        'mage/url'
    ],
    function (Component, additionalValidators, url) {
        'use strict';

        return Component.extend({
            defaults: {
                template: 'Sunpay_SunpayPayment/payment/form',
                sunpayPaymentMethod: '',
                useSunship: 0,
                redirectAfterPlaceOrder: false,
            },

            initObservable: function () {

                this._super()
                    .observe([
                        'sunpayPaymentMethod',
                        'useSunship'
                    ]);
                return this;
            },

            getCode: function() {
                return 'sunpay_payment_gateway';
            },

            getData: function() {
                return {
                    'method': this.item.method,
                    'additional_data': {
                        'sunpay_payment_method': this.sunpayPaymentMethod(),
                        'use_sunship' : this.useSunship(),
                    }
                };
            },

            
            // ⭐ 建立訂單後轉跳
            placeOrder: function (data, event) {
                if (event) {
                    event.preventDefault();
                }

                var self = this;

                // this.validate() 來自父類 Component
                if (this.validate() && additionalValidators.validate()
                ) {
                    // 阻止重複按鈕
                    this.isPlaceOrderActionAllowed(false);

                    // getPlaceOrderDeferredObject() 來自父類，回傳 deferred/promise
                    return this.getPlaceOrderDeferredObject()
                        .done(function (result) {
                            // result 為回傳的 order entity id（可用於後端查 increment_id）
                            var orderId = result;

                            // redirect 並帶上 orderId 與 type
                            window.location.replace(
                                url.build('sunpaysunpaypayment/page/redirecttosunpay?id=' + orderId + '&type=payment')
                            );
                        }).always(function () {
                            self.isPlaceOrderActionAllowed(true);
                        });
                }

                return false;
            },          

            getsunpayPaymentMethods: function() {
                // Sunpay\Payment\Model\Ui\ConfigProvider.php
                return _.map(window.checkoutConfig.payment.sunpay_payment_gateway.sunpayPaymentMethods, function(value, key) {
                    return {
                        'value': key,
                        'text': value
                    }
                });
            },        

            getUseSunshipOptions: function() {
                // Sunpay\Payment\Model\Ui\ConfigProvider.php
                return _.map(window.checkoutConfig.payment.sunpay_payment_gateway.useSunshipOptions, function(value, key) {
                    return {
                        'value': key,
                        'text': value
                    }
                });
            }
        });
    }
);
