define(
    [
        'jquery',
        'mage/translate',
        'Magento_Ui/js/model/messageList',
        'Magento_Checkout/js/model/quote'
    ],
    function ($, $t, messageList, quote) {
        'use strict';
        return {
            validate: function () {

                let isValid = true;
                const paymentMethod = quote.paymentMethod().method;
                const dataDiv = $('#sunpay_payment_field');
                const choosenPaymentMethod = dataDiv.find('select[name="sunpay_payment_method"]').val();
                const useSunShip = dataDiv.find('select[name="use_sunship"]').val();

                var sunpayPaymentMethods = window.checkoutConfig.payment.sunpay_payment_gateway.sunpayPaymentMethods;
                sunpayPaymentMethods =  _.map(sunpayPaymentMethods, function(value, key) {
                    return key;
                });

                const found = sunpayPaymentMethods.find(element => element === choosenPaymentMethod);

                if (paymentMethod === 'sunpay_payment_gateway') {
                    if (found === undefined) {
                        isValid = false;
                    }
                }

                if (!isValid) {
                    messageList.addErrorMessage({ message: $t('Invalid payment method.') });
                }

                return isValid;
            }
        }
    }
);