<?php

namespace Sunpay\SunpayPayment\Plugin\Model\Method;

use Psr\Log\LoggerInterface ;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\ObjectManager;
use Magento\Payment\Model\MethodList;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;

use Sunpay\SunpayPayment\Helper\Services\Config\MainService;
use Sunpay\SunpayPayment\Helper\Services\Config\PaymentService;

class MethodAvailable
{
    protected $_loggerInterface;

    protected $_storeManager;

    protected $_mainService;
    protected $_paymentService;

    public function __construct(
        LoggerInterface $loggerInterface,
        StoreManagerInterface $storeManager,
        MainService $mainService,
        PaymentService $paymentService
    )
    {
        $this->_loggerInterface = $loggerInterface;

        $this->_storeManager = $storeManager;

        $this->_mainService = $mainService;
        $this->_paymentService = $paymentService;
    }

    /**
     * @param Magento\Payment\Model\MethodList $subject
     * @param $result
     * @return array
     */
    public function afterGetAvailableMethods(MethodList $subject, $result)
    {
        $objectManager = ObjectManager::getInstance();
        $cart = $objectManager->get('\Magento\Checkout\Model\Cart');
        $quote = $cart->getQuote();

        // 如果使用紅陽物流，判斷貨到付款付款方式
        $cashOnDeliveryTag = 1;
        $shippingMethod = $quote->getShippingAddress()->getShippingMethod();
        $this->_loggerInterface->debug('MethodAvailable shippingMethod:'. print_r($shippingMethod,true));                

        // 過濾顯示金流
        foreach ($result as $key => $_result) {

            // 紅陽金流顯示檢查
            if ($this->_paymentService->isSunpayPayment($_result->getCode())) {
                // 金流沒有啟用時或幣別不是台幣，關閉所有紅陽金流
                if (!$this->_mainService->isPaymentModuleEnable() || !$this->checkCurrencyCode()) {
                    unset($result[$key]);
                }
            }

            // 關閉貨到付款選項
            if ($cashOnDeliveryTag == 0 && $_result->getCode() == 'cashondelivery') {
                unset($result[$key]);
            }
        }

        return $result;
    }

    /**
     * 幣別檢查，僅限台幣
     *
     * @return bool
     */
    private function checkCurrencyCode()
    {
        $baseCurrencyCode = $this->_storeManager->getStore()->getBaseCurrencyCode();
        $currentCurrencyCode = $this->_storeManager->getStore()->getCurrentCurrencyCode();

        if ($baseCurrencyCode !== 'TWD') {
            return false;
        }

        if ($currentCurrencyCode !== 'TWD') {
            return false;
        }

        return true;
    }
}