<?php
namespace Sunpay\SunpayPayment\Observer;

use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\UrlInterface;
use Magento\Quote\Api\Data\PaymentInterface;
use Psr\Log\LoggerInterface ;

use Sunpay\SunpayPayment\Helper\Services\Common\EncryptionsService;
use Sunpay\SunpayPayment\Helper\Services\Common\OrderService;
use Sunpay\SunpayPayment\Helper\Services\Config\MainService;
use Sunpay\SunpayPayment\Helper\Services\Config\PaymentService;

class OrderSaveAfter  implements ObserverInterface
{
    const KEY_SUNPAY_PAYMENT_METHOD = 'sunpay_payment_method';
    const KEY_USE_SUNSHIP = 'use_sunship';

    /**
     * @var array
     */
    private $additionalInformationList = [
        self::KEY_SUNPAY_PAYMENT_METHOD,
        self::KEY_USE_SUNSHIP
    ];

    protected $_loggerInterface;
    protected $_urlInterface;

    protected $_encryptionsService;
    protected $_orderService;
    protected $_mainService;
    protected $_paymentService;


    public function __construct(
        LoggerInterface $loggerInterface,
        UrlInterface $urlInterface,

        EncryptionsService $encryptionsService,
        OrderService $orderService,
        MainService $mainService,
        PaymentService $paymentService
    )
    {
        $this->_loggerInterface = $loggerInterface;
        $this->_urlInterface = $urlInterface;

        $this->_encryptionsService = $encryptionsService;
        $this->_orderService = $orderService;
        $this->_mainService = $mainService;
        $this->_paymentService = $paymentService;
    }

    public function execute(Observer $observer) {

        $order = $observer->getEvent()->getOrder();
        $orderId = intval($order->getId());
        $status = $order->getStatus() ;

        $this->_loggerInterface->debug('OrderSaveAfter Observer status:' . $status);
        $this->_loggerInterface->debug('OrderSaveAfter Observer orderId:' . $orderId);
        
        // $data = $this->readDataArgument($observer);
        $event = $observer->getEvent();
        $data = $event->getData('input');   // checkout data
        $this->_loggerInterface->debug('OrderSaveAfter Observer data:' . print_r($data,true));
        $this->_loggerInterface->debug('OrderSaveAfter Observer additionalDataKey:' . PaymentInterface::KEY_ADDITIONAL_DATA);

        $additionalData = $data[PaymentInterface::KEY_ADDITIONAL_DATA] ?? [];
        $this->_loggerInterface->debug('OrderSaveAfter Observer additionalData:' . print_r($additionalData,true));

        if (!is_array($additionalData)) {
            return $this;
        }

        $payment = $order->getPayment();

        foreach ($this->additionalInformationList as $key) {
            if (isset($additionalData[$key])) {
                $payment->setAdditionalInformation($key, $additionalData[$key]);
            }
        }

        // 訂單付款方式
        $paymentMethod = $this->_orderService->getPaymentMethod($orderId);
        $this->_loggerInterface->debug('OrderSaveAfter Observer paymentMethod:'.$paymentMethod);

        // 貨到不付款判斷
        $lgs_flag = "0";
        if (isset($additionalData['use_sunship'])) {
            $lgs_flag = strval($additionalData['use_sunship']);
        }
        $this->_loggerInterface->debug('OrderSaveAfter Observer lgs_flag:' . $lgs_flag);

        return $this;
    }
}