<?php
/**
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Sunpay\SunpayPayment\Observer;

use Magento\Framework\Event\Observer;
use Magento\Payment\Observer\AbstractDataAssignObserver;
use Magento\Quote\Api\Data\PaymentInterface;
use Psr\Log\LoggerInterface ;

class DataAssignObserver extends AbstractDataAssignObserver
{
    const KEY_SUNPAY_PAYMENT_METHOD = 'sunpay_payment_method';
    const KET_USE_SUNSHIP = 'use_sunship';

    /**
     * @var array
     */
    private $additionalInformationList = [
        self::KEY_SUNPAY_PAYMENT_METHOD,
        self::KET_USE_SUNSHIP
    ];

    protected $_loggerInterface;

    public function __construct(
        LoggerInterface $loggerInterface
    )
    {
        $this->_loggerInterface = $loggerInterface;
    }

    /**
     * @param Observer $observer
     * @return void
     */
    public function execute(Observer $observer)
    {
        /** 取得前端傳來的 additional_data */
        $data = $this->readDataArgument($observer);

        $additionalData = $data->getData(PaymentInterface::KEY_ADDITIONAL_DATA);

        if (!is_array($additionalData)) {
            return;
        }

        $paymentInfo = $this->readPaymentModelArgument($observer);

        foreach ($this->additionalInformationList as $key) {
            if (isset($additionalData[$key])) {
                $paymentInfo->setAdditionalInformation(
                    $key,
                    $additionalData[$key]
                );
            }
        }
    }
}
