<?php
/**
 * Copyright © 2016 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Sunpay\SunpayPayment\Model\Ui;

use Magento\Checkout\Model\ConfigProviderInterface;

use Sunpay\SunpayPayment\Helper\Services\Config\PaymentService;

/**
 * Class ConfigProvider
 */
final class ConfigProvider implements ConfigProviderInterface
{
    const CODE = 'sunpay_payment_gateway';

    protected $_paymentService;

    /**
     * @param PaymentService $paymentService
     */
    public function __construct(PaymentService $paymentService)
    {
        $this->_paymentService = $paymentService;
    }

    /**
     * Retrieve assoc array of checkout configuration
     *
     * @return array
     */
    public function getConfig()
    {
        $result = $this->_paymentService->getSunpayPaymentMethods();
        $isEnabledSunShipWithPay = $this->_paymentService->getSunShipWithPaySetting();
        $options = array();
        if($isEnabledSunShipWithPay == 1){
            $options = array(
                0 => '否',
                1 => '是',
            );
        }

        return [
            'payment' => [
                self::CODE => [
                    'sunpayPaymentMethods' => $result,
                    'useSunshipOptions' => $options
                ]
            ]
        ];
    }
}
