<?php

namespace Sunpay\SunpayPayment\Helper\Services\Config;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Store\Model\ScopeInterface;

class MainService extends AbstractHelper
{
    /**
     * 購物車名稱
     */
    public const CART_NAME = 'magento';

    /**
     * 購物車開發版本
     */
    public const CART_VERSION = 'v2.4.7-p1';

    public function getConfigValue($field, $storeId = null)
    {
        return $this->scopeConfig->getValue(
            $field, ScopeInterface::SCOPE_STORE, $storeId
        );
    }

    /**
     * Get the module description
     *
     * @return string
     */
    public function getModuleDescription()
    {
        return 'sunpay_module_' . strtolower(self::CART_NAME . '_' . self::CART_VERSION);
    }

    /**
     *   Ex:$code=payment_order_prefix  see:/etc/system.xml
     */
    public function getPaymentConfig($code, $storeId = null)
    {
        $configPath = 'payment/sunpay_payment_gateway/' ;
        return $this->getConfigValue($configPath . $code, $storeId);
    }

    public function getPaymentModuleConfig($configPath, $code, $storeId = null)
    {
        return $this->getConfigValue($configPath .'/'. $code, $storeId);
    }

    /**
     *   Ex:$code=payment_order_prefix  see:/etc/system.xml
     */
    public function getInvoiceConfig($code, $storeId = null)
    {
        $configPath = 'payment/sunpay_payment_gateway/sunpay_invoice/' ;
        return $this->getConfigValue($configPath . $code, $storeId);
    }

    /**
     * 金流模組是否啟動
     *
     * @return bool
     */
    public function isPaymentModuleEnable()
    {
        return $this->getPaymentConfig('enabled_payment_stage');
    }

    /**
     * 發票模組是否啟動
     *
     * @return bool
     */
    public function isInvoiceModuleEnable()
    {
        return $this->getInvoiceConfig('enabled_sunpay_invoice');
    }
}