<?php
namespace Sunpay\SunpayPayment\Helper\Services\Common;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\UrlInterface;
use Magento\Sales\Model\Order;
use Psr\Log\LoggerInterface;

use Sunpay\SunpayPayment\Helper\Foundation\EncryptionsHelper;
use Sunpay\SunpayPayment\Helper\Services\Common\OrderService;
use Sunpay\SunpayPayment\Helper\Services\Common\EncryptionsService;
use Sunpay\SunpayPayment\Helper\Services\Config\PaymentService;
use Sunpay\SunpayPayment\Helper\Services\Config\MainService;

class ToSunpayService extends AbstractHelper
{
    protected $_loggerInterface;
    protected $_urlInterface;
    protected $_encryptionsHelper;
    protected $_mainService;
    protected $_orderService;
    protected $_paymentService;
    protected $_encryptionsService;

    /**
     * @param Context $context
     */
    public function __construct(
        LoggerInterface $loggerInterface,
        UrlInterface $urlInterface,
        EncryptionsHelper $encryptionsHelper,
        MainService $mainService,
        OrderService $orderService,
        PaymentService $paymentService,
        EncryptionsService $encryptionsService
    )
    {
        $this->_loggerInterface = $loggerInterface;
        $this->_urlInterface = $urlInterface;
        $this->_encryptionsHelper = $encryptionsHelper;
        $this->_mainService = $mainService;
        $this->_orderService = $orderService;
        $this->_paymentService = $paymentService;
        $this->_encryptionsService = $encryptionsService;
    }

    /**
     * 組合送往紅陽金流格式
     */
    public function preparePayment($orderId) {
        // 取出是否為測試模式
        $paymentStage = $this->_mainService->getPaymentConfig('enabled_payment_stage');
        $this->_loggerInterface->debug('ToSunpayService preparePayment paymentStage:'. print_r($paymentStage,true));

        // 取出 URL
        $apiUrl = $this->_paymentService->getApiUrl('check_out', $paymentStage);
        $this->_loggerInterface->debug('ToSunpayService preparePayment apiUrl:'. print_r($apiUrl,true));

        // 取出 RSAKey SHA2Key MID
        $paymentMerchantId = $this->_mainService->getPaymentConfig('payment_mid');
        $paymentRSAPublicKey    = $this->_mainService->getPaymentConfig('payment_rsakey');
        $paymentSHA2Key     = $this->_mainService->getPaymentConfig('payment_sha2key');

        $this->_loggerInterface->debug('ToSunpayService preparePayment paymentMerchantId:'. print_r($paymentMerchantId,true));
        $this->_loggerInterface->debug('ToSunpayService preparePayment paymentRSAPublicKey:'. print_r($paymentRSAPublicKey,true));
        $this->_loggerInterface->debug('ToSunpayService preparePayment paymentSHA2Key:'. print_r($paymentSHA2Key,true));

        $accountInfo = [
            'MerchantId' => $paymentMerchantId,
            'RSAPublicKey'    => $paymentRSAPublicKey,
            'SHA2Key'     => $paymentSHA2Key,
        ];

        // $this->_loggerInterface->debug('ToSunpayService preparePayment enctyOrderId:'. print_r($enctyOrderId,true));
        $this->_loggerInterface->debug('ToSunpayService preparePayment orderId:'. print_r($orderId,true));

        // 取出訂單金流方式
        $paymentMethod = $this->_orderService->getPaymentMethod($orderId);
        $this->_loggerInterface->debug('ToSunpayService preparePayment paymentMethod:'. print_r($paymentMethod,true));

        // 取出訂單前綴
        $paymentOrderPreFix = $this->_mainService->getPaymentConfig('payment_order_prefix');
        $this->_loggerInterface->debug('ToSunpayService preparePayment paymentOrderPreFix:'. print_r($paymentOrderPreFix,true));

        // 組合廠商訂單編號
        $merchantTradeNo = $this->_orderService->getMerchantTradeNo($orderId, $paymentOrderPreFix);
        $this->_loggerInterface->debug('ToSunpayService preparePayment merchantTradeNo:'. print_r($merchantTradeNo,true));

        // 取得帳單電子郵件
        $billingEmail = $this->_orderService->getBillingEmail($orderId);
        $this->_loggerInterface->debug('ToSunpayService preparePayment billingEmail:'. print_r($billingEmail,true));

        // 取得帳單收件人
        $billingName = $this->_orderService->getBillingName($orderId);
        $this->_loggerInterface->debug('ToSunpayService preparePayment billingName:'. print_r($billingName,true));

        // 取得帳單連絡電話
        $billingTelephone = $this->_orderService->getBillingTelephone($orderId);
        $this->_loggerInterface->debug('ToSunpayService preparePayment billingTelephone:'. print_r($billingTelephone,true));

        // 訂單金額
        $totalAmount = (int) ceil($this->_orderService->getGrandTotal($orderId));
        $this->_loggerInterface->debug('ToSunpayService preparePayment $totalAmount:'. print_r($totalAmount,true));

        $itemNameDefault = __('A Package Of Online Goods');

        // 取出訂單品項
        $salesOrderItem = $this->_orderService->getSalesOrderItemByOrderId($orderId);
        $this->_loggerInterface->debug('ToSunpayService preparePayment salesOrderItem:'. print_r($salesOrderItem,true));

        // 轉換商品名稱格式
        $itemName = $this->_paymentService->convertToPaymentItemName($salesOrderItem);
        $this->_loggerInterface->debug('ToSunpayService preparePayment itemName:'. print_r($itemName,true));

        // 判斷是否超過長度，如果超過長度改為預設文字
        if (strlen($itemName) > 400) {

            $itemName = $itemNameDefault;

            // 寫入備註
            $comment = '商品名稱超過紅陽金流可允許長度強制改為:' . $itemName;
            $this->_orderService->setOrderCommentForBack($orderId, $comment);
        }
        $this->_loggerInterface->debug('ToSunpayService preparePayment itemName:'. print_r($itemName,true));

        // 回傳資訊網址 - PaymentInfoURL
        $paymentInfoURL = $this->_urlInterface->getUrl('sunpaysunpaypayment/Process/PaymentInfoResponse');
        $paymentInfoURL = $paymentInfoURL . '?id='. $orderId;
        $this->_loggerInterface->debug('ToSunpayService preparePayment $paymentInfoURL:'. print_r($paymentInfoURL,true));

        // 回傳資訊網址 - ReturnURL
        $returnURL = $this->_urlInterface->getUrl('sunpaysunpaypayment/Process/PaymentResponse');
        $returnURL = $returnURL . '?id='. $orderId;
        $this->_loggerInterface->debug('ToSunpayService preparePayment $returnURL:'. print_r($returnURL,true));

        $clientBackURL = $this->_urlInterface->getUrl('sunpaysunpaypayment/Page/ThankYou');
        $clientBackURL = $clientBackURL . '?id='. $orderId;
        $this->_loggerInterface->debug('ToSunpayService preparePayment $clientBackURL:'. print_r($clientBackURL,true));

        // 送出前異動訂單狀態
        $this->_orderService->setOrderState($orderId, Order::STATE_PENDING_PAYMENT);
        $this->_orderService->setOrderStatus($orderId, Order::STATE_PENDING_PAYMENT);

        // 取得額外參數
        $additionalInformation = $this->_orderService->getAdditionalInformation($orderId);
        $this->_loggerInterface->debug('ToSunpayService preparePayment $additionalInformation:'. print_r($additionalInformation,true));

        // 備註及儲存金流廠商訂單編號
        $comment = sprintf(__('SunPay Payment, MerchantTradeNo :%s'), $merchantTradeNo);
        $this->_orderService->setOrderCommentForBack($orderId, $comment);
        $this->_orderService->setOrderData($orderId, 'sunpay_payment_merchant_trade_no', $merchantTradeNo) ;

        //取得send_time
        $sendTime = $this->_encryptionsHelper->get_send_time();
        
        //取得紅陽付款方式
        if(isset($additionalInformation['sunpay_payment_method'])){
            $paymentMethod = $additionalInformation['sunpay_payment_method'];
        }

        //是否為取貨不付款
        $lgs_flag = "0";
        if(isset($additionalInformation['use_sunship'])){
            $lgs_flag = strval($additionalInformation['use_sunship']);
        }

        $input = array(
            'send_time' => $sendTime,
            "paymentMethod" => $paymentMethod,
            "country_type" => "cht",
            "currency" => "TWD",
            "email" => $billingEmail,
            "mn"  => intval($totalAmount),
            "order_info" => $itemName,
            "sdt" => $billingTelephone,
            "sna" => $billingName,
            "td" => $orderId . 'T' . time(),
            "lgs_flag" => $lgs_flag,
        );
        $this->_loggerInterface->debug('ToSunpayService preparePayment $clientBackURL:'. print_r($input,true));

        return $this->_paymentService->checkout($accountInfo, $input, $apiUrl);
    }
}