<?php

namespace Sunpay\SunpayPayment\Helper\Services\Common;

use Sunpay\SunpayPayment\Helper\Foundation\EncryptionsHelper;
use Sunpay\SunpayPayment\Helper\Foundation\SunpayPaymentHelper;
use Magento\Framework\App\Helper\AbstractHelper;

class EncryptionsService extends AbstractHelper
{
    /**
     * EncryptionsHelper
     *
     * @var EncryptionsHelper
     */
    protected $_encryptionsHelper ;

    /**
     * Helper
     *
     * @var SunpayPaymentHelper
     */
    protected $_sunpaypaymentHelper ;

    /**
     * @param EncryptionsHelper $encryptionsHelper
     * @param SunpayPaymentHelper $sunpaypaymentHelper
     */
	public function __construct(
        EncryptionsHelper $encryptionsHelper,
        SunpayPaymentHelper $sunpaypaymentHelper
    ) {
		$this->_encryptionsHelper = $encryptionsHelper;
		$this->_sunpaypaymentHelper = $sunpaypaymentHelper;
	}

    /**
     * 產生 AES KEY、IV
     *
     * @param  string $cipher
     * @param  int    $keylen
     * @param  bool   $ivTag
     * @return array  $aes
     */
    public function aesGenerate(string $cipher, int $keylen = 32, bool $ivTag = true)
    {
        $aes['key'] = $this->_sunpaypaymentHelper->random($keylen);

        if ($ivTag) {
            $ivlen = openssl_cipher_iv_length($cipher);
            $aes['iv'] = $this->_sunpaypaymentHelper->random($ivlen);
        }

        return $aes;
    }

    /**
     * 資料加密
     *
     * @param  string $data
     * @return string $encData
     */
    public function encrypt($data)
    {
        // 取得 KEY、IV
        $aes = $this->_sunpaypaymentHelper->getInvoiceEncryKey();

        $encData = $this->_encryptionsHelper->urlEncode($data);
        $encData = $this->_encryptionsHelper->aesEncrypt($encData, $aes['hash_key'], $aes['hash_iv']);
        $encData = $this->_encryptionsHelper->base64Encode($encData);

        return $encData;
    }

    /**
     * 資料解密
     *
     * @param  string $data
     * @return string $decData
     */
    public function decrypt($data)
    {
        // 取得 KEY、IV
        $aes = $this->_sunpaypaymentHelper->getInvoiceEncryKey();

        $decData = $this->_encryptionsHelper->base64Decode($data);
        $decData = $this->_encryptionsHelper->aesDecrypt($decData, $aes['hash_key'], $aes['hash_iv']);
        $decData = $this->_encryptionsHelper->urlDecode($decData);

        return $decData;
    }
}