<?php

namespace Sunpay\SunpayPayment\Helper\Foundation;

use Magento\Framework\App\DeploymentConfig;
use Magento\Framework\App\Helper\AbstractHelper;

class SunpayPaymentHelper extends AbstractHelper
{
    public const CONFIG_PATH_SUNPAY_SUNPAYPAYMENT  = 'payment/sunpay_payment_gateway/';
    public const CONFIG_PATH_SUNPAY_INVOICE  = 'payment/sunpay_payment_gateway/sunpay_invoice/';

    /**
     * Deployment configuration
     *
     * @var DeploymentConfig
     */
    protected $_deploymentConfig ;

    /**
     * @param DeploymentConfig $deploymentConfig
     */
	public function __construct(
        DeploymentConfig $deploymentConfig
    ) {
		$this->_deploymentConfig = $deploymentConfig;
	}

    /**
     * 取 env.php sunpay/payment 資料
     *
     * @param  string $path
     * @return mixed
     */
    public function getSunpayPaymentConfigData(string $path)
    {
        return $this->_deploymentConfig->get(self::CONFIG_PATH_SUNPAY_SUNPAYPAYMENT . $path);
    }

    /**
     * 取 env.php sunpay/payment 資料
     *
     * @param  string $path
     * @return mixed
     */
    public function getSunpayInvoiceConfigData(string $path)
    {
        return $this->_deploymentConfig->get(self::CONFIG_PATH_SUNPAY_INVOICE . $path);
    }

    /**
     * 從 env.php 中取出 KEY、IV
     *
     * @return array
     */
    public function getInvoiceEncryKey()
    {
        $info = [
            'hash_key' => $this->getSunpayInvoiceConfigData('/ei_hash_key'),
            'hash_iv'  => $this->getSunpayInvoiceConfigData('/ei_hash_iv'),
        ] ;

        return $info;
    }

    /**
     * 從 env.php 中取出 KEY、IV
     *
     * @return array
     */
    public function getRSAEncryKey()
    {
        $info = [
            'rsa_public_key' => $this->getSunpayPaymentConfigData('/payment_rsakey'),
            'sha2_key'  => $this->getSunpayPaymentConfigData('/payment_sha2key'),
        ] ;

        return $info;
    }

    /**
     * Generate a more truly "random" alpha-numeric string.
     *
     * @param  int    $length
     * @return string
     */
    public function random($length = 16)
    {
        $string = '';

        while (($len = strlen($string)) < $length) {
            $size = $length - $len;

            $bytes = random_bytes($size);

            $string .= substr(str_replace(['/', '+', '='], '', base64_encode($bytes)), 0, $size);
        }

        return $string;
    }
}