<?php

namespace Sunpay\SunpayPayment\Helper\Foundation;

use Magento\Framework\App\Helper\AbstractHelper;
use Exception;

class EncryptionsHelper extends AbstractHelper
{
	public function get_encrypted_data($data, $rsa_public_key, $sha2_key){

		$publicKey  = openssl_pkey_get_public("-----BEGIN PUBLIC KEY-----\n".
		chunk_split($rsa_public_key, 64, "\n").
		"-----END PUBLIC KEY-----\n");

		//將所有參數進行升序
		ksort($data);
		foreach ($data as $key => $value) {
			ksort($value);
			$data[$key] = $value;
		}
		//將data轉為json
		$data_json = json_encode($data, 320);
		//將json進行urlencode
		$data_encode = $this->java_urlencode($data_json);
		//取得RSA加密資料
		$rsamsg = $this->rsa_public_encrypt_b64($data_encode, $publicKey);
		//取得SHA2檢查碼
		$check_value = $this->sha256_encrypt($data_encode, $sha2_key);
		//回傳加密資料
		$rtn_data = array(
			"rsamsg" => $rsamsg,
			"check_value" => $check_value
		);
		return $rtn_data;
	}

	public function java_urlencode($data_json){
		$data_encode = urlencode($data_json);
		//特殊字元轉換
		$data_encode = str_replace('%2A','*',$data_encode);
		$data_encode = str_replace('~','%7E',$data_encode);
		
		return $data_encode;
	}

	public function get_decrypted_data($encrypted_data, $rsa_public_key, $sha2_key){

		$publicKey  = openssl_pkey_get_public("-----BEGIN PUBLIC KEY-----\n".
		chunk_split($rsa_public_key, 64, "\n").
		"-----END PUBLIC KEY-----\n");

		//取得RSA解密資料
		$decrypted_data_encode = $this->rsa_public_decrypt_b64($encrypted_data, $publicKey);	
		//將json進行urldecode
		$decrypted_data_json = urldecode($decrypted_data_encode);
		//將data轉為array
		$decrypted_data = json_decode($decrypted_data_json, true);
		if(empty($decrypted_data)){
			throw new Exception("解密失敗");
		}
		//取得SHA2檢查碼
		$check_value = $this->sha256_encrypt($decrypted_data_encode, $sha2_key);
		//回傳加密資料
		$rtn_data = array(
			"data" => $decrypted_data,
			"check_value" => $check_value
		);
		return $rtn_data;
	}

	/**
	 * 取得單塊可加密的最大長度（依金鑰與 padding）
	 */
	function rsa_max_encrypt_chunk_len($publicKey, int $padding): int {
		$details = openssl_pkey_get_details($publicKey);
		$keyBytes = (int) ($details['bits'] / 8);

		// 依 padding 不同，最大可加密長度不同
		// PKCS1 v1.5: keyBytes - 11
		// OAEP(sha1): keyBytes - 2*20 - 2 = keyBytes - 42
		if ($padding === OPENSSL_PKCS1_PADDING) {
			return $keyBytes - 11;
		} elseif ($padding === OPENSSL_PKCS1_OAEP_PADDING) {
			return $keyBytes - 42; // PHP OpenSSL 使用 SHA-1 的 OAEP 預設參數
		} else {
			// 其他 padding 不支援作資料加密
			throw new Exception("不支援的 padding");
		}
	}

	/**
	 * 公鑰加密（自動切塊，回傳 base64）
	 */
	function rsa_public_encrypt_b64(string $plaintext, $publicKey, int $padding = OPENSSL_PKCS1_PADDING): string {
		$chunkLen = $this->rsa_max_encrypt_chunk_len($publicKey, $padding);
		$chunks = str_split($plaintext, $chunkLen);

		$encryptedAll = '';
		foreach ($chunks as $chunk) {
			$ok = openssl_public_encrypt($chunk, $encryptedChunk, $publicKey, $padding);
			if (!$ok) {
				throw new Exception("公鑰加密失敗：" . openssl_error_string());
			}
			$encryptedAll .= $encryptedChunk;
		}
		return base64_encode($encryptedAll);
	}

	/**
	 * 公鑰解密 (分段)
	 */
	function rsa_public_decrypt_b64(string $rsamsg, $publicKey, int $padding = OPENSSL_PKCS1_PADDING): string {
        $rsamsg = str_replace(array('-', '_'), array('+', '/'), $rsamsg);  //需要轉一些符號才能解
		$cipher = base64_decode($rsamsg, true);
		if ($cipher === false) {
			throw new Exception("Base64 解碼失敗");
		}

		$details = openssl_pkey_get_details($publicKey);
		$chunkLen = $details['bits'] / 8;

		$chunks = str_split($cipher, $chunkLen);
		$decryptedAll = '';
		foreach ($chunks as $chunk) {
			if (!openssl_public_decrypt($chunk, $decryptedChunk, $publicKey, $padding)) {
				throw new Exception("公鑰解密失敗：" . openssl_error_string());
			}
			$decryptedAll .= $decryptedChunk;
		}
		return $decryptedAll;
	}

	/**
	 * MPG sha256加密
	 *
	 * @access private
	 * @param string $str ,string $key, string $iv
	 * @version 1.4
	 * @return string
	 */
	public function sha256_encrypt( $str, $key ) {
		return hash( 'sha256', $str.$key );
	}

	/**
	 * 取得send_time
	 */
	public function get_send_time(){
		//固定使用台灣時間(UTC+8)
		date_default_timezone_set("Asia/Taipei");
        //send_time格視為fffssmmHHyyyyMMdd
        $datetime = date("siHYmd");
        $microsecond = substr(floor(microtime(true) * 1000), -3);
        $sendTime = $microsecond.$datetime;

		return $sendTime;
	}

    /**
     * check sha value
     */
    public function chkShaIsVaildByReturnData($return_data, $local_check_value, $merchantID)
    {
        //檢查商家代號
        if(isset($return_data['web']) && $return_data['web'] != $merchantID){
            return false;
        }
        if (empty($return_data['check_value'])) {
            return false;
        }
        if (empty($return_data['rsamsg'])) {
            return false;
        }
        if ($return_data['check_value'] != $local_check_value) {
            return false;
        }
        return true;
    }

    // 初始化陣列 避免部分交易回傳值差異導致PHP NOTICE
    public function init_array_data($arr = array(), $indexes = '')
    {
        $index_array = explode(',', $indexes);
        foreach ($index_array as $val) {
            $init_array[$val] = null;
        }
        if (!empty($arr)) {
            return array_merge($init_array, $arr);
        }
        return $init_array;
    }
	
	/**
	 * AES加密
	 * 
	 * @access public
	 * @param array 
	 * @param string
	 * @param string
	 * @return string
	 */
	function aesEncrypt($data, $key, $iv){ 
		$cipher = "AES-128-CBC";
		$options = OPENSSL_RAW_DATA;
		$encrypted = openssl_encrypt($data, $cipher, $key, $options, $iv);
		return base64_encode($encrypted);
	}

	/**
	 * AES解密
	 * 
	 * @access public
	 * @param array 
	 * @param string
	 * @param string
	 * @return string
	 */
	public function aesDecrypt($data, $key, $iv){ 
		$cipher = "AES-128-CBC";
		$options = OPENSSL_RAW_DATA;
		$data = base64_decode($data);
		$decrypted = openssl_decrypt($data, $cipher, $key, $options, $iv);
		return $decrypted;
	}

	/**
     * 編碼 URL 字串
     *
     * @param  string  $data
     * @return string
     */
    public function urlEncode($data)
    {
        $encoded = urlencode($data);

        // 取代為與 .net 相符字元
        $search   = ['%2d', '%5f', '%2e', '%21', '%2a', '%28', '%29'];
        $replace  = ['-', '_', '.', '!', '*', '(', ')'];
        $replaced = str_ireplace($search, $replace, $encoded);

        return $replaced;
    }

    /**
     * 解碼 URL 字串
     *
     * @param  string  $data
     * @return string
     */
    public function urlDecode($data)
    {
        return urldecode($data);
    }

	/**
     * Base64編碼
     *
     * @param  string $encode
     * @return array
     */
    public function base64Encode($data)
    {
        return base64_encode($data);
    }

    /**
     * Base64解碼
     *
     * @param  string $encoded
     * @return array
     */
    public function base64Decode($encoded)
    {
        return base64_decode($encoded);
    }
}