<?php
namespace Sunpay\SunpayPayment\Controller\Process;

use Exception;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Framework\App\RequestInterface;
use Magento\Sales\Model\Order;
use Magento\Framework\UrlInterface;

use Psr\Log\LoggerInterface ;

use Sunpay\SunpayPayment\Helper\Services\Common\EncryptionsService;
use Sunpay\SunpayPayment\Helper\Services\Common\OrderService;
use Sunpay\SunpayPayment\Helper\Services\Common\MailService;
use Sunpay\SunpayPayment\Helper\Services\Config\MainService;
use Sunpay\SunpayPayment\Helper\Services\Config\PaymentService;
use Sunpay\SunpayPayment\Helper\Foundation\EncryptionsHelper;
use Sunpay\SunpayPayment\Helper\Foundation\SunpayPaymentHelper;
use Sunpay\SunpayPayment\Model\SunpayPaymentInfo;

class PaymentInfoResponse extends Action implements CsrfAwareActionInterface
{

    protected $_loggerInterface;
    protected $_requestInterface;
    protected $_urlInterface;

    protected $_encryptionsService;
    protected $_orderService;

    protected $_mainService;
    protected $_paymentService;

    protected $_encryptionsHelper;
    protected $_sunpaypaymentHelper;

    protected $_sunpayPaymentInfoFactory;

    public function __construct(
        LoggerInterface $loggerInterface,
        UrlInterface $urlInterface,
        Context $context,
        RequestInterface $requestInterface,

        EncryptionsService $encryptionsService,
        OrderService $orderService,

        MainService $mainService,
        PaymentService $paymentService,

        EncryptionsHelper $encryptionsHelper,
        SunpayPaymentHelper $sunpaypaymentHelper,

        SunpayPaymentInfo $sunpayPaymentInfoFactory
    )
    {
        $this->_loggerInterface = $loggerInterface;
        $this->_requestInterface = $requestInterface;
        $this->_urlInterface = $urlInterface;

        $this->_encryptionsService = $encryptionsService;
        $this->_orderService = $orderService;

        $this->_mainService = $mainService;
        $this->_paymentService = $paymentService;

        $this->_encryptionsHelper = $encryptionsHelper;
        $this->_sunpaypaymentHelper = $sunpaypaymentHelper;

        $this->_sunpayPaymentInfoFactory = $sunpayPaymentInfoFactory;

        return parent::__construct($context);
    }

    public function execute()
    {
        // 接收金流資訊
        $paymentInfo = $this->_requestInterface->getPostValue();
        $this->_loggerInterface->debug('PaymentInfoResponse paymentInfo:'. print_r($paymentInfo,true));

        $successUrl = $this->_urlInterface->getUrl('checkout/onepage/success/');
        $errorUrl = $this->_urlInterface->getUrl('checkout/onepage/failure/');

        if (!isset($paymentInfo['rsamsg'])) {
            throw new Exception('Get SunPay feedback failed.');
            return $this->resultRedirectFactory->create()->setUrl($errorUrl);
        } else {

            $req_data = array();
            $paymentMerchantId = $this->_mainService->getPaymentConfig('payment_mid');
            $paymentRSAPublicKey    = $this->_mainService->getPaymentConfig('payment_rsakey');
            $paymentSHA2Key     = $this->_mainService->getPaymentConfig('payment_sha2key');
            if (!empty($this->_paymentService->sanitize_text_field($paymentInfo['rsamsg']))) {
                $req_data = $this->_encryptionsHelper->get_decrypted_data(
                    $this->_paymentService->sanitize_text_field($paymentInfo['rsamsg']),
                    $paymentRSAPublicKey,
                    $paymentSHA2Key
                );
                if (!$this->_encryptionsHelper->chkShaIsVaildByReturnData($paymentInfo, $req_data['check_value'], $paymentMerchantId)) {
                    throw new Exception("檢查碼錯誤");
                    return $this->resultRedirectFactory->create()->setUrl($errorUrl);
                }
                if (!is_array($req_data) || 
                (isset($req_data['data']) && !is_array($req_data['data']))) {
                    throw new Exception("解密失敗");
                    return $this->resultRedirectFactory->create()->setUrl($errorUrl);
                }
            }
            $this->_loggerInterface->debug('PaymentInfoResponse req_data:'. print_r($req_data,true));

            // 初始化$req_data 避免因index不存在導致NOTICE 若無傳入值的index將設為null
            $init_indexes_head  = 'send_time,web';
            $head = $this->_encryptionsHelper->init_array_data($req_data['data']['head'],$init_indexes_head);
            $init_indexes_body  = 'approve_code,card_no,card_type,currency,mn,name,note1,note2,pay_agency,pay_agency_memo,
                                pay_date,pay_result,pay_time,td,trade_no,save_card_token_result,user_no';                                                     //付款完成之回傳參數欄位
            $init_indexes_body .= 'delivery_type,store_id,store_name,store_type,lgs_type,receiver_name,receiver_phone';                                          //超商物流之回傳參數欄位
            $init_indexes_body .= 'account_id,account_name,bank_code,banc_name,due_date,pay_code,barcodeA,barcodeB,barcodeC';                                    //取號完成之回傳參數欄位
            $body = $this->_encryptionsHelper->init_array_data($req_data['data']['body'],$init_indexes_body);
            $req_data = array(
                "body" => $body,
                "head" => $head
            );

            $orderId = trim($req_data['body']['td']);
            $re_Status  = trim($req_data['body']['pay_result']) != '' ? trim($req_data['body']['pay_result']) : null;
            $re_Amt     = $req_data['body']['mn'];
            $re_CardType = $req_data['body']['card_type'];

            // 檢查回傳狀態是否為成功
            $msg = "";
            $is_success = true;
            if ($re_Status != "10") {
                $msg = '訂單處理失敗: ';
                if($re_Status == "12" && $re_CardType == "09"){
                    //超商取貨另外處理
                    $msg = "訂單已建立,等待付款";
                }else{
                    if($re_Status == "12" && str_contains("06,07,08",$re_CardType)){
                        //非即時性付款
                        $msg = "訂單已建立,等待付款";
                    }else if($re_Status == "11"){
                        $msg .= "交易失敗";
                        $is_success = false;
                    }else if($re_Status == "12"){
                        $msg .= "訂單已建立過";
                        $is_success = false;
                    }
                }
            }

            $orderCurrencyCode = $this->_orderService->getOrderCurrencyCode($orderId);
            $orderTotal = (!$orderCurrencyCode) ? $this->_orderService->getGrandTotal($orderId) : $this->_orderService->getBaseGrandTotal($orderId);
            // 符合AIO金額無條件進位到整數
            $orderTotal = (int)ceil($orderTotal);

            if (!$this->_paymentService->validAmount($re_Amt, $orderTotal)) {
                $this->_loggerInterface->debug('PaymentInfoResponse $paymentInfo.TradeAmt:'. print_r($paymentInfo['TradeAmt'], true));
                $this->_loggerInterface->debug('PaymentInfoResponse $orderTotal:'. print_r($orderTotal, true));
                throw new Exception('Order amount are not identical.');
                return $this->resultRedirectFactory->create()->setUrl($errorUrl);
            } else {

                // 訂單狀態判斷
                $createStatus = [Order::STATE_PENDING_PAYMENT, 'sunpay_pending_payment'];
                $orderStatus = $this->_orderService->getStatus($orderId);
                $this->_loggerInterface->debug('PaymentInfoResponse $orderStatus:'. print_r($orderStatus, true));

                // 非即時性付款(超商取貨付款另外處理)
                if(str_contains("06,07,08",$re_CardType)){
                    try{
                        // 檢查是否付款
                        if (empty($req_data['body']['pay_date']) || empty($req_data['body']['pay_time'])) {
                            $comment = '訂單付款方式屬非即時性付款,尚未付款';
                            $this->_orderService->setOrderCommentForBack($orderId, $comment);
                            throw new Exception($this->_paymentService->esc_attr($comment));
                        }
                    }catch(Exception $e){
                        $msg .= '處理'.$this->_paymentService->getSunpayPaymentMethodsName($re_CardType).'失敗,';
                        $msg .= '錯誤訊息:' . $e->getMessage();
                        $this->_orderService->setOrderCommentForBack($orderId, $msg);
                        $this->_orderService->setOrderState($orderId, Order::STATE_CANCELED);
                        $this->_orderService->setOrderStatus($orderId, Order::STATE_CANCELED);
                        throw new Exception($this->_paymentService->esc_attr($msg));
                        return $this->resultRedirectFactory->create()->setUrl($errorUrl);
                    }            
                }

                if (in_array($orderStatus, $createStatus)) {

                    // 寄送付款資訊信件
                    // 組合信件內容參數
                    $paymentType = $this->_paymentService->getSunpayPaymentMethodsName($re_CardType);
                    $templateValues = [
                        'real_order_id'        => $this->_orderService->getRealOrderId($orderId),
                        'created_at_formatted' => $this->_orderService->getCreatedAtFormatted($orderId, 2),
                        'payment_type'         => $paymentType,
                        'total_amount'         => intval($this->_orderService->getGrandTotal($orderId)),
                    ];
                    $this->_loggerInterface->debug('PaymentInfoResponse $templateValues:'. print_r($templateValues, true));
                }
            }
        }
        
        return $this->resultRedirectFactory->create()->setUrl($successUrl);
    }

    /**
     * 儲存 paymentinfo 回傳資料
     *
     * @param  string $orderId
     * @param  array  $response
     * @return void
     */
    public function saveSunpayPaymentInfo(string $orderId, array $response)
    {
        $sunpayPaymentInfoModel = $this->_sunpayPaymentInfoFactory->create();
        $paymentInfoData = [
            'td'                => $orderId,
            'approve_code'       => $response['approve_code'],
            'card_no' => $response['card_no'],
            'currency'          => $response['currency'],
            'mn'          => $response['mn'],
            'name'           => $response['name'],
            'note1'          => $response['note1'],
            'note2'         => $response['note2'],
            'pay_agency'      => $response['pay_agency'],
            'pay_agency_memo'        => $response['pay_agency_memo'],
            'pay_date'     => $response['pay_date'],
            'pay_result'     => $response['pay_result'],
            'pay_time'     => $response['pay_time'],
            'trade_no'     => $response['trade_no'],
            'save_card_token_result'     => $response['save_card_token_result'],
            'user_no'     => $response['user_no'],
            'delivery_type'     => $response['delivery_type'],
            'store_id'     => $response['store_id'],
            'store_name'     => $response['store_name'],
            'store_type'     => $response['store_type'],
            'lgs_type'     => $response['lgs_type'],
            'receiver_name'     => $response['receiver_name'],
            'receiver_phone'     => $response['receiver_phone'],
            'account_id'     => $response['account_id'],
            'account_name'     => $response['account_name'],
            'bank_code'     => $response['bank_code'],
            'banc_name'     => $response['banc_name'],
            'due_date'     => $response['due_date'],
            'pay_code'     => $response['pay_code'],
            'barcodeA'     => $response['barcodeA'],
            'barcodeB'     => $response['barcodeB'],
            'barcodeC'     => $response['barcodeC'],
        ];

        $sunpayPaymentInfoModel->addData($paymentInfoData);
        $sunpayPaymentInfoModel->save();
    }

    /**
     * @inheritDoc
     */
    public function createCsrfValidationException(
        RequestInterface $requestInterface
    ): ?InvalidRequestException {

        return null;
    }

    /**
     * @inheritDoc
     */
    public function validateForCsrf(RequestInterface $requestInterface): ?bool
    {
        return true;
    }
}