<?php
namespace Sunpay\SunpayPayment\Block\Onepage;

use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;
use Psr\Log\LoggerInterface;

use Sunpay\SunpayPayment\Helper\Services\Common\EncryptionsService;
use Sunpay\SunpayPayment\Helper\Services\Common\OrderService;
use Sunpay\SunpayPayment\Helper\Services\Config\PaymentService;

class ThankYou extends Template
{
    protected $_checkoutSession;

    protected $_loggerInterface;

    protected $_encryptionsService;
    protected $_orderService;

    protected $_paymentService;

    protected $orderId;

    public function __construct(
        Context $context,
        CheckoutSession $checkoutSession,
        LoggerInterface $loggerInterface,
        EncryptionsService $encryptionsService,
        OrderService $orderService,
        PaymentService $paymentService,
        array $data = []
    ) {
        $this->_checkoutSession = $checkoutSession;
        $this->_loggerInterface = $loggerInterface;

        $this->_encryptionsService = $encryptionsService;
        $this->_orderService = $orderService;

        $this->_paymentService = $paymentService;

        parent::__construct($context, $data);

        $this->orderId = $this->getOrderId();
        $this->_loggerInterface->debug('ThankYou Block orderId:'. print_r($this->orderId,true));
    }

    /**
     * 檢查 Order ID，是否顯示
     *
     * @return bool
     */
    public function isShow()
    {
        return ($this->orderId !== 0);
    }

    /**
     * @return Order
     */
    public function getOrder()
    {
        return $this->_orderService->getOrder($this->orderId);
    }

    /**
     * @return Payment
     */
    public function getPayment()
    {
        return $this->getOrder()->getPayment();
    }

    /**
     * 取得訂單資訊
     *
     * @return array
     */
    public function getOrderInfo()
    {
        return [
            'real_order_id' => $this->_orderService->getRealOrderId($this->orderId),
            'created_at'    => $this->_orderService->getCreatedAt($this->orderId),
            'amount'        => $this->_orderService->getBaseGrandTotal($this->orderId),
            'state'         => $this->_orderService->getOrderState($this->orderId),
        ];
    }

    /**
     * 取得付款資訊
     *
     * @return array
     */
    public function getPaymentInfo()
    {
        $paymentMethod = $this->_orderService->getPaymentMethod($this->orderId);
        $methodTitle = $this->getPayment()->getMethodInstance()->getTitle();
        $this->_loggerInterface->debug('ThankYou Block paymentMethod:'. print_r($paymentMethod,true));
        $this->_loggerInterface->debug('ThankYou Block methodTitle:'. print_r($methodTitle,true));

        $isSunpayPayment = $this->_paymentService->isSunpayPayment($paymentMethod);
        $this->_loggerInterface->debug('ThankYou Block isSunpayPayment:'. print_r($isSunpayPayment,true));

        // 判斷是否為紅陽金流
        $paymentInfo = [];
        if ($isSunpayPayment) {
            $paymentInfo = $this->_orderService->getSunpayPaymentInfoContent($this->orderId, $paymentMethod);
        }
        $this->_loggerInterface->debug('ThankYou Block paymentInfo:'. print_r($paymentInfo,true));

        return [
            'is_sunpay_payment' => ($isSunpayPayment) ? 'Y' : 'N',
            'payment_method'   => $methodTitle,
            'payment_info'     => $paymentInfo,
        ];
    }

    /**
     * @return string
     */
    public function getContinueUrl()
    {
        return $this->_storeManager->getStore()->getBaseUrl();
    }

    /**
     * 取得訂單編號
     *
     * @return int
     */
    private function getOrderId()
    {
        // 解密訂單編號
        $orderId = $this->getRequest()->getParam('id') ;
        $orderId = str_replace(' ', '+', $orderId) ;

        $this->_loggerInterface->debug('ThankYou Block orderId:'. print_r(intval($orderId),true));

        return intval($orderId);
    }

    /**
     *  Payment custom error message
     *
     * @return string
     */
    public function getErrorMessage()
    {
        $error = $this->_checkoutSession->getErrorMessage();
        return $error;
    }
}