<?php
namespace Sunpay\SunpayPayment\Block\Onepage;

use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;
use Psr\Log\LoggerInterface;

use Sunpay\SunpayPayment\Helper\Services\Common\EncryptionsService;
use Sunpay\SunpayPayment\Helper\Services\Common\OrderService;
use Sunpay\SunpayPayment\Helper\Services\Common\ToSunpayService;
use Sunpay\SunpayPayment\Helper\Services\Config\PaymentService;

class RedirectToSunpay extends Template
{
    protected $_checkoutSession;

    protected $_loggerInterface;

    protected $_encryptionsService;
    protected $_orderService;
    protected $_toSunpayService;

    protected $_paymentService;

    protected $orderId;

    public function __construct(
        Context $context,
        CheckoutSession $checkoutSession,
        LoggerInterface $loggerInterface,
        EncryptionsService $encryptionsService,
        OrderService $orderService,
        ToSunpayService $toSunpayService,
        PaymentService $paymentService,
        array $data = []
    ) {
        $this->_checkoutSession = $checkoutSession;
        $this->_loggerInterface = $loggerInterface;

        $this->_encryptionsService = $encryptionsService;
        $this->_orderService = $orderService;
        $this->_toSunpayService = $toSunpayService;

        $this->_paymentService = $paymentService;

        parent::__construct($context, $data);
    }

    /**
     * 產生紅陽金、物流表單後至前端 echo
     */
    public function getFormHtml() {
        $orderId = $this->getRequest()->getParam('id');
        $formType = $this->getRequest()->getParam('type');

        $this->_loggerInterface->debug('RedirectToSunpay Block getFormHtml $orderId:'.$orderId);
        $this->_loggerInterface->debug('RedirectToSunpay Block getFormHtml $formType:'.$formType);
        if ($formType == 'payment'){
            $form = $this->_toSunpayService->preparePayment($orderId);
            //設定 Success Session
            $order = $this->_orderService->getOrder($orderId);
            $this->_checkoutSession
                ->setLastQuoteId($order->getQuoteId())
                ->setLastSuccessQuoteId($order->getQuoteId())
                ->setLastOrderId($order->getId())
                ->setLastRealOrderId($order->getIncrementId())
                ->clearHelperData();        
        }

        return $form;
    }
}