define([
    'jquery',
    'mage/utils/wrapper',
    'Magento_CheckoutAgreements/js/model/agreements-assigner',
    'Magento_Checkout/js/model/quote',
    'Magento_Customer/js/model/customer',
    'Magento_Checkout/js/model/url-builder',
    'mage/url',
    'Magento_Checkout/js/model/error-processor',
    'uiRegistry'
], function (
    $, 
    wrapper, 
    agreementsAssigner,
    quote,
    customer,
    urlBuilder, 
    urlFormatter, 
    errorProcessor,
    registry
) {
    'use strict';

    return function (placeOrderAction) {

        /** Override default place order action and add agreement_ids to request */
        return wrapper.wrap(placeOrderAction, function (originalAction, paymentData, messageContainer) {
            agreementsAssigner(paymentData);
            var isCustomer = customer.isLoggedIn();
            var quoteId = quote.getQuoteId();

            var url = urlFormatter.build('sunpayinvoice/frontend/save');

            var sunpayInvoiceCarruerType          = $('[name="sunpay_invoice_carruer_type"]').val();
            var sunpayInvoiceType                 = $('[name="sunpay_invoice_type"]').val();
            var sunpayInvoiceCustomerIdentifier   = $('[name="sunpay_invoice_customer_identifier"]').val();
            var sunpayInvoiceCustomerCompany      = $('[name="sunpay_invoice_customer_company"]').val();
            var sunpayInvoiceLoveCode             = $('[name="sunpay_invoice_love_code"]').val();
            var sunpayInvoiceCarruerNum           = $('[name="sunpay_invoice_carruer_num"]').val();

            if (sunpayInvoiceType) {

                var payload = {
                    'cartId': quoteId,
                    'is_customer': isCustomer,
                    'sunpay_invoice_carruer_type': sunpayInvoiceCarruerType,
                    'sunpay_invoice_type': sunpayInvoiceType,
                    'sunpay_invoice_customer_identifier': sunpayInvoiceCustomerIdentifier,
                    'sunpay_invoice_customer_company': sunpayInvoiceCustomerCompany,
                    'sunpay_invoice_love_code': sunpayInvoiceLoveCode,
                    'sunpay_invoice_carruer_num': sunpayInvoiceCarruerNum
                };

                if (!payload.sunpay_invoice_type || !payload.sunpay_invoice_carruer_type) {
                    return true;
                }
                
                var result = true;

                $.ajax ({
                    url: url,
                    data: payload,
                    dataType: 'text',
                    type: 'POST',
                }).done (
                    function (response) {
                        result = true;
                    }
                ).fail (
                    function (response) {
                        result = false;
                        errorProcessor.process(response);
                    }
                );
            }

            return originalAction(paymentData, messageContainer);
        });
    };
});
                               