define([
    'jquery',
    'mage/utils/wrapper',
    'Magento_Checkout/js/model/quote',
], function ($, wrapper, quote) {
    'use strict';

    return function (setShippingInformationAction) {
        return wrapper.wrap(setShippingInformationAction, function (originalAction) {

            // 重置欄位style及error msg
            $("#sunpay_invoice_love_code").removeAttr("style");
            $("#sunpay_invoice_customer_identifier").removeAttr("style");
            $("#sunpay_invoice_customer_company").removeAttr("style");
            $("#sunpay_invoice_carruer_num").removeAttr("style");
            $("#love_code_error").empty();
            $("#customer_identifier_error").empty();
            $("#customer_company_error").empty();
            $("#carruer_num_error").empty();

            var error = false;
            
            // 依照發票開立類型判斷需驗證欄位(個人B2C、公司B2B)
            var sunpay_invoice_type = $("#sunpay_invoice_type").val();
            switch (sunpay_invoice_type) {
                case 'B2C':
                    var sunpay_invoice_carruer_type = $("#sunpay_invoice_carruer_type").val();
                    if(sunpay_invoice_carruer_type == 4){
                        var sunpay_invoice_love_code = $("#sunpay_invoice_love_code").val();
                        // 未填寫捐贈碼
                        if (sunpay_invoice_love_code == '' || sunpay_invoice_love_code == null) {
                            addErrorMsg('love_code', 'This is a required field.')
                        }
                        else {
                            // 驗證捐贈碼
                            var data = {
                                'loveCode': sunpay_invoice_love_code
                            }
                            verifyAjax('love_code', 'rest/V1/sunpay_sunpaypayment/invoice/check_love_code', data);
                        }
                    }else{
                        if (sunpay_invoice_carruer_type == '1' || sunpay_invoice_carruer_type == '2') {
                            // 個人發票選擇載具選項
                            var sunpay_invoice_carruer_num = $("#sunpay_invoice_carruer_num").val();
                            if (sunpay_invoice_carruer_num == '' || sunpay_invoice_carruer_num == null) {
                                addErrorMsg('carruer_num', 'This is a required field.')
                            }
                            else {
                                // 驗證載具手機條碼(1)、自然人憑證(2)
                                if (sunpay_invoice_carruer_type == '2') {
                                    var path_url = 'rest/V1/sunpay_sunpaypayment/invoice/check_citizen_digital_certificate';
                                    var data = {
                                        'carrierNumber': sunpay_invoice_carruer_num
                                    }
                                }
                                else {
                                    var path_url = 'rest/V1/sunpay_sunpaypayment/invoice/check_barcode';
                                    var data = {
                                        'barcode': sunpay_invoice_carruer_num
                                    }
                                }
                                verifyAjax('carruer_num', path_url, data);
                            }
                        }
                    }
                    break;
                case 'B2B':
                    var sunpay_invoice_customer_identifier = $("#sunpay_invoice_customer_identifier").val();
                    var sunpay_invoice_carruer_type = $("#sunpay_invoice_carruer_type").val();
                    var sunpay_invoice_company = $("#sunpay_invoice_customer_company").val();

                    // 未填寫公司統編
                    if (sunpay_invoice_customer_identifier == '' || sunpay_invoice_customer_identifier == null) {
                        addErrorMsg('customer_identifier', 'This is a required field.')
                    }
                    else {
                        var data = {
                            'businessNumber': sunpay_invoice_customer_identifier
                        }
                        verifyAjax('customer_identifier', 'rest/V1/sunpay_sunpaypayment/invoice/check_business_number', data);
                    }

                    // 紙本發票未填寫公司行號
                    if (sunpay_invoice_company == '' || sunpay_invoice_company == null) {
                        addErrorMsg('customer_company', 'This is a required field.')
                    }

                    break;
                default:
                    // 個人發票
                    var sunpay_invoice_carruer_type = $("#sunpay_invoice_carruer_type").val();
                    if (sunpay_invoice_carruer_type == '1' || sunpay_invoice_carruer_type == '2') {
                        // 個人發票選擇載具選項
                        var sunpay_invoice_carruer_num = $("#sunpay_invoice_carruer_num").val();
                        if (sunpay_invoice_carruer_num == '' || sunpay_invoice_carruer_num == null) {
                            addErrorMsg('carruer_num', 'This is a required field.')
                        }
                        else {
                            // 驗證載具手機條碼(1)、自然人憑證(2)
                            if (sunpay_invoice_carruer_type == '2') {
                                var path_url = 'rest/V1/sunpay_sunpaypayment/invoice/check_citizen_digital_certificate';
                                var data = {
                                    'carrierNumber': sunpay_invoice_carruer_num
                                }
                            }
                            else {
                                var path_url = 'rest/V1/sunpay_sunpaypayment/invoice/check_barcode';
                                var data = {
                                    'barcode': sunpay_invoice_carruer_num
                                }
                            }
                            verifyAjax('carruer_num', path_url, data);
                        }
                    }
                    break;
            }

            // 驗證欄位Ajax
            function verifyAjax(field, url_path, data) {
                $.ajax({ 
                    type: 'POST',
                    url: window.BASE_URL + url_path,
                    headers: {
                        'Content-Type': 'application/json; charset=utf-8',
                        'dataType': 'json',
                    },
                    async: false,
                    data: JSON.stringify(data),
                    error: function(response) {
                        var errorMsg = response.responseJSON;
                        addErrorMsg(field, errorMsg.message + ' (' + errorMsg.code + ')')
                    },
                    success: function(response) {
                        let res_data = JSON.parse(response);
                        if (res_data.code != '0999') {
                            addErrorMsg(field, res_data.msg + ' (' + res_data.code + ')')
                        }
                    }
                });
            }

            // 顯示特定欄位錯誤訊息
            function addErrorMsg(field, msg) {
                $("#sunpay_invoice_" + field).css({'border-color': '#ed8380'});
                $("#sunpay_invoice_" + field).focus();
                $("#" + field + "_error").empty();
                $("#" + field + "_error").append('<span>' + msg + '</span>');
                error = true;
            }

            if (error) return false;

            var result = originalAction();
            return result;
        });
    };
});
             