<?php
namespace Sunpay\Invoice\Plugin\Checkout;

use Psr\Log\LoggerInterface;
use Sunpay\SunpayPayment\Helper\Services\Config\MainService;
use Sunpay\SunpayPayment\Helper\Services\Common\OrderService;

class LayoutProcessorPlugin
{
    protected $_loggerInterface;
    protected $_mainService;
    protected $_orderService;

    public function __construct(
        LoggerInterface $loggerInterface,
        MainService $mainService, 
        OrderService $orderService
    ){
        $this->_loggerInterface = $loggerInterface;
        $this->_mainService = $mainService;
        $this->_orderService = $orderService;
    }
    /**
     * @param \Magento\Checkout\Block\Checkout\LayoutProcessor $subject
     * @param array $jsLayout
     * @return array
     */
    public function afterProcess(
        \Magento\Checkout\Block\Checkout\LayoutProcessor $subject,
        array  $jsLayout
    ) {
        $sunpayEnableIvoice = $this->_mainService->isInvoiceModuleEnable();
        $this->_loggerInterface->debug('checkout page invoice status:'. print_r($sunpayEnableIvoice, true));

        $attributeCode = 'custom_form';
        $fieldConfiguration = [
            'component' => 'Sunpay_Invoice/js/custom-attributes-form',
            'config' => [
                'customScope' => 'shippingAddress.extension_attributes',
                'template' => 'Sunpay_Invoice/custom-attributes-form',
                'id' => 'custom_form'
            ],
            'dataScope' => 'shippingAddress.extension_attributes' . '.' . $attributeCode,
            'label' => __('Custom Form'),
            'provider' => 'checkoutProvider',
            'visible' => true,
            'validation' => [],
            'sortOrder' => 200,
            'validation' => [
                'required-entry' => true
            ],
            'id' => 'custom_form',
            'options' => [],
            'filterBy' => null,
            'customEntry' => null,
            'value' => ''
        ];

        if ($sunpayEnableIvoice != 1) {
            $jsLayout['components']['checkout']['children']['steps']['children']['shipping-step']['children']
                ['shippingAddress']['children']['before-form']['children'][$attributeCode]['visible'] = false;
        }
        else {
            $jsLayout['components']['checkout']['children']['steps']['children']['shipping-step']['children']
                ['shippingAddress']['children']['before-form']['children'][$attributeCode] = $fieldConfiguration;
        }

        return $jsLayout;
    }
}