<?php

namespace Sunpay\Invoice\Block\Adminhtml\Order;

use Sunpay\SunpayPayment\Model\SunpayInvoice;
use Sunpay\SunpayPayment\Helper\Services\Common\EncryptionsService;
use Sunpay\SunpayPayment\Helper\Services\Common\OrderService;
use Sunpay\SunpayPayment\Helper\Services\Config\MainService;
use Sunpay\SunpayPayment\Helper\Services\Config\InvoiceService;
use Magento\Backend\Block\Template\Context;
use Magento\Framework\Registry;
use Magento\Sales\Helper\Admin;
use Magento\Sales\Block\Adminhtml\Order\AbstractOrder;

class OrderInvoice extends AbstractOrder
{
    protected $_encryptionsService;
    protected $_orderService;
    protected $_mainService;
    protected $_invoiceService;

    protected $orderId;

    public function __construct(
        Context $context,
        Registry $registry,
        Admin $adminHelper,
        EncryptionsService $encryptionsService,
        OrderService $orderService,
        MainService $mainService,
        InvoiceService $invoiceService,
        array $data = []
    ){

        $this->_encryptionsService = $encryptionsService;
        $this->_orderService = $orderService;
        $this->_mainService = $mainService;
        $this->_invoiceService = $invoiceService;

        parent::__construct($context, $registry, $adminHelper, $data);

        $this->orderId = (int) $this->getOrder()->getId();
    }

    public function getTitle()
    {
        return 'Invoice Method';
    }

    /**
     * 發票模組是否啟動
     *
     * @return bool
     */
    public function getIvoiceModuleEnable()
    {
        return $this->_mainService->isInvoiceModuleEnable();
    }

    /**
     * 取得加密資料
     *
     * @return string $encryptData
     */
    public function getEncryptData()
    {
        $encryptData = [
            'order_id'     => $this->orderId,
            'protect_code' => $this->_orderService->getProtectCode($this->orderId),
        ];

        return json_encode($encryptData);
    }

    /**
     * 取得發票資料
     *
     * @return string
     */
    public function getInvoiceData()
    {
        // 取得發票資料
        $invoiceTypeCode = $this->_orderService->getsunpayInvoiceType($this->orderId);
        if(empty($invoiceTypeCode)){
            return json_encode(array());
        }

        $invoiceData = [
            'sunpay_invoice_tag'           => $this->_orderService->getSunpayInvoiceTag($this->orderId),
            'sunpay_invoice_type'          => $this->_invoiceService->getInvoiceTypeTable()[$invoiceTypeCode],
            'sunpay_invoice_date'          => $this->_orderService->getSunpayInvoiceDate($this->orderId),
            'sunpay_invoice_issue_type'    => $this->_orderService->getSunpayInvoiceIssueType($this->orderId),
            'sunpay_invoice_number'        => $this->_orderService->getSunpayInvoiceNumber($this->orderId),
            'sunpay_invoice_od_sob'        => $this->_orderService->getSunpayInvoiceOdSob($this->orderId),
            'sunpay_invoice_random_number' => $this->_orderService->getSunpayInvoiceRandomNumber($this->orderId),
        ];

        // 依照 sunpayInvoiceType 加入資料
        $extension = [];
        switch ($invoiceTypeCode) {
            case SunpayInvoice::SUNPAY_INVOICE_TYPE_B2C:
                $extension = [
                    'sunpay_invoice_carruer_num' => $this->_orderService->getSunpayInvoiceCarruerNum($this->orderId),
                ];
                break;
            case SunpayInvoice::SUNPAY_INVOICE_TYPE_B2B:
                $extension = [
                    'sunpay_invoice_customer_company' => $this->_orderService->getSunpayInvoiceCustomerCompany($this->orderId),
                    'sunpay_invoice_customer_identifier' => $this->_orderService->getSunpayInvoiceCustomerIdentifier($this->orderId),
                ];
                break;
            // case SunpayInvoice::SUNPAY_INVOICE_TYPE_D:
            //     $extension = [
            //         'sunpay_invoice_love_code' => $this->_orderService->getSunpayInvoiceLoveCode($this->orderId),
            //     ];
            //     break;
        }
        $invoiceData = array_merge($invoiceData, $extension);

        return json_encode($invoiceData);
    }
}
