Magento2.4 紅陽科技金流、電子發票模組
===============

目錄
-----------------
* [支援版本](#支援版本)
* [安裝前置作業](#安裝前置作業)
* [紅陽模組安裝步驟](#紅陽模組安裝步驟)
    * [解壓縮安裝檔](#解壓縮安裝檔)
    * [模組目錄放置規則](#模組目錄放置規則)
    * [模組啟用指令](#模組啟用指令)
    * [更新指令](#更新指令)
* [啟用模組](#啟用模組)
    *  [金流模組](#金流模組)
    *  [發票模組](#發票模組)
* [功能參數設定](#功能參數設定)
* [技術支援](#技術支援)
* [參考資料](#參考資料)

支援版本
-----------------
| Magento | PHP |
| :-----: | :-----: |
|  2.4.7-p3  |  8.1  |

安裝前置作業
-----------------
* 模組安裝前的composer套件安裝

    > 1.修正SameSite問題

    安裝套件
    ```
    # 使用 Composer 1 執行以下指令
    composer require veriteworks/cookiefix ^2

    # 使用 Composer 2 執行以下指令
    composer require veriteworks/cookiefix
    ```
    啟用套件
    ```
    php bin/magento module:enable Veriteworks_CookieFix
    php bin/magento setup:upgrade
    php bin/magento setup:di:compile
    php bin/magento setup:static-content:deploy -f
    php bin/magento cache:clean
    ```

    * 安裝後至後台調整設定： `STORE` > `Configuration` > `GENERAL` > `Web` > `Default Cookie` `Settings` > `SameSite` > `None`


紅陽模組安裝步驟
-----------------
#### 解壓縮安裝檔
將下載的檔案解壓縮，完成後請參照下方[模組目錄放置規則](#模組目錄放置規則)，把紅陽模組放置對應的網站目錄下，再執行[模組啟用指令](#模組啟用指令)及[更新指令](#更新指令)。

※ 提醒：<br>
* 若存在舊版模組，請先移除並且清除快取再上傳。<br>
* 做完任何設定調整，都需清除快取，才能使用調整後的設定，以下為清除快取的購物車網站路徑：
    ```
    購物車後台 ＞ SYSTEM ＞ Cache Management ＞ Flush Magento Cache
    ```

#### 模組目錄放置規則
* 請複製壓縮檔中的 `app` 資料夾到 Magento 購物車的根目錄資料夾。

#### 模組啟用指令
請先執行 `模組啟用指令` 再執行 [更新指令](#更新指令)。

※ 提醒：使用電子發票模組需啟用 `Sunpay_SunpayPayment` (紅陽金流模組)。
```
php bin/magento module:enable Sunpay_SunpayPayment

php bin/magento module:enable Sunpay_Invoice
```

#### 更新指令
請按順序執行以下指令。
```
php bin/magento setup:upgrade
php bin/magento setup:di:compile
php bin/magento setup:static-content:deploy -f
php bin/magento cache:flush
```
 * 執行後請確認檔案權限為Magento站台檔案擁有者。

啟用模組
-----------------
#### 金流模組

> * 啟用 `主要設定` 中的 `金流`
> * 啟用金流模組：`購物車後台` ＞ `STORES` ＞ `Configuration` ＞ `SALES` ＞ `Payment Methods` ＞ `OTHER PAYMENT METHODS` ＞ `SunPay Payment`

#### 發票模組

> * 啟用發票模組：`購物車後台` ＞ `STORES` ＞ `Configuration` ＞ `SALES` ＞ `Payment Methods` ＞ `OTHER PAYMENT METHODS` ＞ `SunPay Payment` ＞ `Sunpay Invoice`

功能參數設定
-----------------
#### 金流模組
* 金流共用設定：`購物車後台` ＞ `STORES` ＞ `Configuration` ＞ `SALES` ＞ `Payment Methods` ＞ `OTHER PAYMENT METHODS` ＞ `SunPay Payment`。
    1. 訂單編號前綴：紅陽訂單編號長度限制20，超過會自動截斷。
    2. 紅陽訂單顯示商品名稱：關閉時，商品名稱固定帶入 `網路商品一批`。
    3. 啟用測試模式：啟用測試模式時，測試信用卡資料為。
        - 一次付清: 卡號:4938170188888994 到期日:1228 卡片後三碼:541
        - 分期付款: 卡號:5430450130000033 到期日:1228 卡片後三碼:534
    4. 商店代號(Merchant ID)
    5. RSA公鑰(RSA Public Key)
    6. SHA2密鑰(SHA2 Key)
    7. 各支付方式是否開啟(預設為關閉) 
        - 信用卡刷卡（含分期付款）
        - Apple Pay / Google Pay
        - 銀聯卡刷卡
        - 超商繳費單繳費
        - 超商代碼繳費
        - 超商取貨付款
        - ATM轉帳（虛擬帳號）
        - 網路ATM轉帳
        - 街口支付
        - 超商取貨不付款

    設定完成後請點選 `SaveConfig` 儲存。

#### 發票模組
* 發票設定：`購物車後台` ＞ `STORES` ＞ `Configuration` ＞ `SALES` ＞ `Payment Methods` ＞ `OTHER PAYMENT METHODS` ＞ `SunPay Payment` ＞ `Sunpay Invoice`
    1. 統一編號：賣家統一編號。
    2. 商店代號(Merchant ID)
    3. 金鑰(Hash Key)
    4. 向量(Hash IV)
    5. 發票簡訊通知：如需使用本服務，請確認是否啟用加值服務。若有疑問，請與業務窗口諮詢確認。
    6. 紅陽代印發票：無載具時才會套用，如需使用本服務，請確認是否啟用加值服務。若有疑問，請與業務窗口諮詢確認。
    7. 課稅別
    8. 稅率：課稅別為應稅(特種)時才需填寫，請帶入規定之稅率，例如：規定之稅率為18%，稅率請帶入【0.18】

    設定完成後請點選 `SaveConfig` 儲存。

* 後台訂單相關操作：進入 `購物車後台` ＞ `SALES` ＞ `Orders` ＞ `訂單詳細頁面` 可執行以下動作。
    1. 開立發票

注意事項
-----------------
* 本模組不支援後台訂單 Reorder 功能

技術支援
-----------------
營業時間 週一～週五 09:00-20:30
紅陽金流客服電話 02-2502-6969
紅陽金流客服信箱: service@esafe.com.tw

參考資料
-----------------
#### 金流
* 登入特店專區
* [測試區](https://testmerchant.sunpay.com.tw/)
* [正式區](https://merchant.sunpay.com.tw/)
#### 發票
* 登入特店專區
* [測試區](https://testinv.sunpay.com.tw/)
* [正式區](https://einv.sunpay.com.tw/)

#### 金流轉跳網址
* 前台首頁網址/sunpaysunpaypayment/Process/PaymentInfoResponse
#### 金流通知網址
* 前台首頁網址/sunpaysunpaypayment/Process/PaymentResponse
