<?php
require_once SUNPAY_MAIN_PATH . '/includes/sunpay/baseSunpayMPG.php';

class WC_sunpay extends baseSunpayMPG
{
    public $MerchantID;
    public $RSAPublicKey;
    public $SHA2Key;
    public $TestMode;
    public $gateway;
    public $paymentCheck;
    public $sunpayTool;
    public $sunpaySelectedPayment;
    public $useSunship;
    //發票
    public $ei;
    public $inv_gateway;
    public $eiEnable;
    public $eiCompanyID;
    public $eiMerchantID;
    public $eiHashKey;
    public $eiHashIV;
    public $eiIsSendMessage;
    public $eiIsSendPaper;
    public $eiTaxType;
    public $eiTaxRate;

    public function __construct()
    {
        $this->id  = 'sunpay';
        $this->icon = apply_filters('woocommerce_sunpay_icon', plugins_url('icon/sunpay.png', dirname(dirname(__FILE__))));

        $this->has_fields         = false;
        $this->method_title       = __('紅陽金流', 'sunpay');
        $this->method_description = __('透過紅陽科技整合金流輕鬆付款', 'sunpay');

        // Load the form fields.
        $this->init_form_fields();

        // Load the settings.
        $this->init_settings();

        // Define user set variables
        // $this->title        = $this->get_option('title');
        $this->title        = ""; //$this->get_option('title');
        $this->description  = $this->get_option('description');
        $this->MerchantID   = trim($this->get_option('web_value'));
        $this->RSAPublicKey = trim($this->get_option('web_rsa_public_key'));
        $this->SHA2Key      = trim($this->get_option('web_sha2_key'));
        $this->TestMode     = $this->get_option('test_mode');

        // Test Mode
        if ($this->TestMode == 'yes') {
            $this->gateway     = 'https://testtrade.sunpay.com.tw/v4/cash'; // 測試網址
            $this->paymentCheck  = 'https://testtrade.sunpay.com.tw/v4/query/PaymentCheck';
        } else {
            $this->gateway     = 'https://trade.sunpay.com.tw/v4/cash'; // 正式網址
            $this->paymentCheck  = 'https://trade.sunpay.com.tw/v4/query/PaymentCheck';
        }

        // 發票
        $this->eiEnable        = $this->get_option('eiEnable');
        $this->eiCompanyID     = trim($this->get_option('eiCompanyID'));
        $this->eiMerchantID    = trim($this->get_option('eiMerchantID'));
        $this->eiHashKey       = trim($this->get_option('eiHashKey'));
        $this->eiHashIV        = trim($this->get_option('eiHashIV'));
        $this->eiIsSendMessage = trim($this->get_option('eiIsSendMessage'));
        $this->eiIsSendPaper   = trim($this->get_option('eiIsSendPaper'));
        $this->eiTaxType       = trim($this->get_option('eiTaxType'));
        $this->eiTaxRate       = trim($this->get_option('eiTaxRate'));

        $eiData = array(
            'eiEnable'      => $this->eiEnable,
            'companyID'     => $this->eiCompanyID,
            'merchantID'    => $this->eiMerchantID,
            'HashKey'       => $this->eiHashKey,
            'HashIV'        => $this->eiHashIV,
            'IsSendMessage' => $this->eiIsSendMessage,
            'IsSendPaper'   => $this->eiIsSendPaper,
            'taxType'       => $this->eiTaxType,
            'taxRate'       => $this->eiTaxRate,
            'testMode'     => $this->TestMode
        );
        $this->ei = sunpayElectronicInvoice::get_instance($eiData);

        $this->base_action_init();
        $this->sunpayTool = sunpayTool::get_instance();

        // add_filter( 'woocommerce_thankyou_page', array( $this, 'thankyou_page' ) ); // 商店付款完成頁面
        add_filter('woocommerce_thankyou_order_received_text', array($this, 'order_received_text'));
    }

    /**
     * Initialise Gateway Settings Form Fields
     *
     * @access public
     * @return void
     * 後台欄位設置
     */
    function init_form_fields()
    {
        $this->form_fields = include SUNPAY_MAIN_PATH . '/includes/sunpay/sunpaySetting.php';
    }

    /**
     * Admin Panel Options
     * - Options for bits like 'title' and availability on a country-by-country basis
     *
     * @access public
     * @return void
     */
    public function admin_options()
    {
        echo '<h1>' . '紅陽金流 收款模組' . '</h1>';;
        echo '<p>' . '此模組可以讓您使用紅陽金流的收款功能' . '</p>';
        echo '<p>' . '請先至紅陽官網申請會員並且啟用相關支付工具' . '</p>';
        echo '<table class="form-table">';
        $this->generate_settings_html();
        echo '</table>';

        // 引用js
        wp_enqueue_script(
            'my_custom_script',
            plugins_url('assets/js/admin/sunpaySetting.js', dirname(dirname(__FILE__))),
            array('jquery')
        );
    }

    /**
     * Get sunpay Args for passing to sunpay
     *
     * @access public
     * @param mixed $order
     * @return array
     *
     * MPG參數格式
     */
    private function get_sunpay_args($order)
    {
        $merchant_order_no = $order->get_id() . 'T' . time(); // prevent duplicate
        $order->update_meta_data('_sunpayMerchantOrderNo', $merchant_order_no);
        $order->save();

        //取得send_time
        $sendTime = $this->sunpayTool->get_send_time();
        
        $head = array(
            "send_time" => $sendTime,
            "web" => $this->MerchantID
        );

        //取得付款方式
        $notes = $order->get_customer_order_notes();
        $notes_str = $notes[0]->comment_content;
        $notes_arr = explode(",",$notes_str);
        $payment_method = $this->convert_payment_method_to_code($notes_arr[0]);
        $is_use_sunship = false;
        if(count($notes_arr) > 1 && $notes_arr[1] == "useSunship"){
            $is_use_sunship = true;
        }

        $body = array(
            "card_type" => $payment_method,
            "country_type" => "cht",
            "currency" => "TWD",
            "email" => $order->get_billing_email(),
            "mn"  => strval(round($order->get_total())),
            "order_info" => $this->genetateItemDescByOrderItem($order),
            "sdt" => $order->get_billing_phone(),
            "sna" => $order->get_billing_last_name() . $order->get_billing_first_name(),
            "td" => $merchant_order_no,
        );
        //分期付款必要欄位
        if($payment_method == "01" && $notes[0]->comment_content == "buysafemul"){
            $body["term"] = "3";
        }
        //超商條碼/超商代碼選用欄位
        if($payment_method == "06" || $payment_method == "07"){
            // $body["bill_date"] = date("Ymd");
            // $body["due_date"] = "7";
            // $product_data = array();
            // $products = $order->get_items();
            // foreach($products AS $product){
            //     $product_data[] = array(
            //         "no" => $product->get_product_id(),
            //         "product_name" => $product->get_name(),
            //         "product_price" => round($product->get_subtotal() / $product->get_quantity()),
            //         "product_quantity" => $product->get_quantity(),
            //     );
            // }
            // $body["product"] = $product_data;
        }
        //虛擬帳號選用欄位
        if($payment_method == "08"){
            // $body["due_date"] = "7";
        }
        //超商取貨付款
        if($payment_method == "09"){
            // $body["receiver_name"] = $order->get_billing_last_name() . $order->get_billing_first_name();
            // $body["receiver_phone"] = $order->get_billing_phone();
            // $body["receiver_mail"] = $order->get_billing_email();
            $body["lgs_flag"] = "1";
        }
        // ksort($body);
        if($is_use_sunship){
            $body['lgs_flag'] = "1";
        }

        $data = array(
            "body" => $body,
            "head" => $head,
        );

        $encrypted_data = $this->sunpayTool->get_encrypted_data($data, $this->RSAPublicKey, $this->SHA2Key);
        $rsamsg    = $encrypted_data['rsamsg'];
        $check_value = $encrypted_data['check_value'];

        // print_r($data);
        // exit();

        $post_data = array(
            "web" => $this->MerchantID,
            "send_time" => $sendTime,
            "rsamsg" => $rsamsg,
            "check_value" => $check_value
        );

        return $post_data;
    }

    /**
     * 依照訂單產生物品名稱
     *
     * @access private
     * @param order $order
     * @version 2.0
     * @return string
     */
    private function genetateItemDescByOrderItem($order)
    {
        if (!isset($order)) {
            return '';
        }
        $item_name = $order->get_items();
        $item_cnt  = 1;
        $itemdesc  = '';
        foreach ($item_name as $item_value) {
            if ($item_cnt != count($item_name)) {
                $itemdesc .= $item_value->get_name() . ' × ' . $item_value->get_quantity() . '，';
            } elseif ($item_cnt == count($item_name)) {
                $itemdesc .= $item_value->get_name() . ' × ' . $item_value->get_quantity();
            }

            $item_cnt++;
        }
        return $itemdesc;
    }

    public function order_received_text()
    {
        $req_data = array();

        // prevent other maker's payment method to show this text
        if (!isset($_REQUEST['rsamsg'])) {
            return;
        }

        if (!empty(sanitize_text_field($_REQUEST['rsamsg']))) {
            $req_data = $this->sunpayTool->get_decrypted_data(
                sanitize_text_field($_REQUEST['rsamsg']),
                $this->RSAPublicKey,
                $this->SHA2Key
            );
            if (!$this->sunpayTool->chkShaIsVaildByReturnData($_REQUEST, $req_data['check_value'], $this->MerchantID)) {
                echo '請重新填單';
                exit();
            }
            if (!is_array($req_data) || 
               (isset($req_data['data']) && !is_array($req_data['data']))) {
                echo '解密失敗';
                exit; // 一定要有離開，才會被正常執行
            }
            if(isset($req_data['check_value']) && $req_data['check_value'] != $_REQUEST['check_value']){
                echo '檢查碼錯誤';
                exit; // 一定要有離開，才會被正常執行
            }
        }

        // 初始化$req_data 避免因index不存在導致NOTICE 若無傳入值的index將設為null
        $init_indexes_head  = 'send_time,web';
        $head = $this->sunpayTool->init_array_data($req_data['data']['head'],$init_indexes_head);
        $init_indexes_body  = 'approve_code,card_no,card_type,currency,mn,name,note1,note2,pay_agency,pay_agency_memo,
                               pay_date,pay_result,pay_time,td,trade_no,save_card_token_result,user_no';                                                     //付款完成之回傳參數欄位
        $init_indexes_body .= 'delivery_type,store_id,store_name,store_type,lgs_type,receiver_name,receiver_phone';                                          //超商物流之回傳參數欄位
        $init_indexes_body .= 'account_id,account_name,bank_code,banc_name,due_date,pay_code,barcodeA,barcodeB,barcodeC';                                    //取號完成之回傳參數欄位
        $body = $this->sunpayTool->init_array_data($req_data['data']['body'],$init_indexes_body);
        $req_data = array(
            "body" => $body,
            "head" => $head
        );

        if (!empty($req_data['td'])) {
            // $order_id = wc_get_order_id_by_order_key(sanitize_text_field($_GET['key']));
            $order_id = explode("T",$req_data['td'])[0];
            $order    = wc_get_order($order_id);   // 原$_REQUEST['order-received']
            $order->set_transaction_id($req_data['trade_no']);
            $order->save();
        }

        if (empty($order)) {
            return '交易失敗，請重新填單';
            exit();
        }

        if (empty($req_data['card_type']) || empty($req_data['pay_status'])) {
            return '交易失敗，請重新填單<br>錯誤代碼：' . esc_attr($req_data['pay_status']) . '<br>錯誤訊息：' . esc_attr($this->convert_status($req_data['pay_status']));
            exit();
        }

        $result = '付款方式：' . esc_attr($this->get_payment_type_str($req_data['card_type'])) . '<br>';
        switch ($req_data['card_type']) {
            case '01':
                //信用卡(一次付清/分期)
            case '02':
                //銀聯卡
            case '03':
                //ApplePay / GooglePay
            case '06':
                //超商代碼繳費
                // if ($req_data['pay_status'] == '10') {
                //     $result .= '交易成功<br>';
                // } else {
                //     $result .= '交易失敗，請重新填單<br>錯誤代碼：' . esc_attr($req_data['pay_status']) . '<br>錯誤訊息：' . esc_attr($this->convert_status($req_data['pay_status']));
                // }
                break;
            case '07':
                //超商條碼繳費
                // if (!empty($req_data['BankCode']) && !empty($req_data['CodeNo'])) {

                //     $result .= '取號成功<br>';
                //     $result .= '銀行代碼：' . esc_attr($req_data['BankCode']) . '<br>';
                //     $result .= '繳費代碼：' . esc_attr($req_data['CodeNo']) . '<br>';
                // } else {
                //     $result .= '交易失敗，請重新填單<br>錯誤代碼：' . esc_attr($req_data['pay_status']) . '<br>錯誤訊息：' . esc_attr($this->convert_status($req_data['pay_status']));
                // }
                break;
            case '08':
                //虛擬帳號
                // if (!empty($req_data['CodeNo'])) {
                //     $result .= '取號成功<br>';
                //     $result .= '繳費代碼：' . esc_attr($req_data['CodeNo']) . '<br>';
                // } else {
                //     $result .= '交易失敗，請重新填單<br>錯誤代碼：' . esc_attr($req_data['pay_status']) . '<br>錯誤訊息：' . esc_attr($this->convert_status($req_data['pay_status']));
                // }
                break;
            case '09':
                //超商取貨付款
                // if (!empty($req_data['Barcode_1']) || !empty($req_data['Barcode_2']) || !empty($req_data['Barcode_3'])) {
                //     $result .= '取號成功<br>';
                //     $result .= '請前往信箱列印繳費單<br>';
                // } else {
                //     $result .= '交易失敗，請重新填單<br>錯誤代碼：' . esc_attr($req_data['pay_status']) . '<br>錯誤訊息：' . esc_attr($this->convert_status($req_data['pay_status']));
                // }
                break;
            case '10':
                //街口支付
                // if (empty($req_data['receiver_name']) || empty($req_data['store_name']) || empty($req_data['StoreAddr'])) {
                //     $result .= '交易失敗，請重新填單<br>錯誤代碼：' . esc_attr($req_data['pay_status']) . '<br>錯誤訊息：' . esc_attr($this->convert_status($req_data['pay_status']));
                // }
                break;
            default:
                // 未來新增之付款方式
                if ($req_data['pay_status'] == '10') {
                    $result .= '付款方式：' . esc_attr($req_data['card_type']) . '<br>';
                    if (!empty($req_data['ExpireDate'])) {
                        $result .= '非即時付款，詳細付款資訊請從信箱確認<br>';    // 非即時付款 部分非即時付款可能沒ExpireDate
                    } else {
                        $result .= '交易成功<br>';    // 即時付款
                    }
                    $result .= '紅陽金流交易序號：' . esc_attr($req_data['trade_no']) . '<br>';
                    break;
                }
                break;
        }
        if (!empty($req_data['receiver_name']) || !empty($req_data['store_name']) || !empty($req_data['store_id']) || !empty($req_data['store_type'])) {
            $order_id  = (isset($order_id)) ? $order_id : $req_data['td'];
            $storeType = urldecode($req_data['store_type']); // 門市類型: 1:7-11, 2:全家, 3:OK, 4:萊爾富
            $storeName = urldecode($req_data['store_name']); // 門市名稱
            $storeAddr = urldecode($req_data['store_id']); // 門市編號
            $name      = urldecode($req_data['receiver_name']); // 取貨人姓名
            $phone     = $req_data['receiver_phone'];
            $result .= '<br>取貨人：' . esc_attr($name) . '<br>電話：' . esc_attr($phone) . '<br>店家：' . esc_attr($storeName) . '<br>地址：' . esc_attr($storeAddr) . '<br>';
            $result .= '請等待超商通知取貨<br>';
            if (empty($order->get_meta('_sunpayStoreName'))) {
                $order->update_meta_data('_sunpayStoreType', $storeType);
                $order->update_meta_data('_sunpayStoreName', $storeName);
                $order->update_meta_data('_sunpayStoreAddr', $storeAddr);
                $order->update_meta_data('_sunpayConsignee', $name);
                $order->update_meta_data('_sunpayConsigneePhone', $phone);
                $order->save();
            }
        }

        if ($req_data['pay_status'] != '10') {
            if ($order->is_paid()) {
                $order->add_order_note(__('Payment failed within paid order', 'sunpay'));
                $order->save();
            } else {
                $order->update_status('failed', sprintf(
                    'Payment failed: %1$s (%2$s)',
                    $req_data['pay_status'],
                    $this->convert_status($req_data['pay_status'])
                ));
            }
        } else {
            $order->update_status('processing');
        }

        return $result;
    }

    /**
     * Output for the order received page.
     *
     * @access public
     * @return void
     */
    function thankyou_page()
    {
        $order_id = wc_get_order_id_by_order_key(sanitize_text_field($_GET['key']));
        $order    = wc_get_order($order_id);   // 原$_REQUEST['order-received']

        $result = "";

        if (empty($order)) {
            return '交易失敗，請重新填單';
            exit();
        }

        $req_data_json = $order->get_meta('_sunpayResponseData');
        if(empty($req_data_json)){
            return '交易失敗，請重新填單';
            exit();
        }

        $req_data = json_decode($req_data_json, true);

        if (empty($req_data['body']['card_type']) || empty($req_data['body']['pay_result'])) {
            return '交易失敗，請重新填單<br>錯誤代碼：' . esc_attr($req_data['body']['pay_result']) . '<br>錯誤訊息：' . esc_attr($this->convert_status($req_data['body']['pay_result']));
            exit();
        }

        $result .= '付款方式：' . esc_attr($this->get_payment_type_str($req_data['body']['card_type'])) . '<br>';
        switch ($req_data['body']['card_type']) {
            case '01':
                //信用卡(一次付清/分期)
            case '02':
                //銀聯卡
            case '03':
                //ApplePay / GooglePay
            case '10':
                //街口支付
                if ($req_data['body']['pay_result'] == '10') {
                    // $result .= '付款方式：' . esc_attr($req_data['body']['card_type']) . '<br>';
                    $result .= '交易成功<br>';    // 即時付款
                    $result .= '紅陽金流交易序號：' . esc_attr($req_data['body']['trade_no']) . '<br>';
                }else{
                    // $result .= '付款方式：' . esc_attr($req_data['body']['card_type']) . '<br>';
                    $result .= '交易失敗，請重新填單<br>錯誤代碼：' . esc_attr($req_data['body']['pay_result']) . '<br>錯誤訊息：' . esc_attr($this->convert_status($req_data['body']['pay_result'])).'<br>';    // 即時付款
                    $result .= '紅陽金流交易序號：' . esc_attr($req_data['body']['trade_no']) . '<br>';
                }
                break;
            case '06':
                //超商代碼繳費
            case '07':
                //超商條碼繳費
            case '08':
                //虛擬帳號
            case '09':
                //超商取貨付款
                if ($req_data['pay_status'] == '12') {
                    // $result .= '付款方式：' . esc_attr($req_data['body']['card_type']) . '<br>';
                    $result .= '取號成功，請於期限內付款<br>';    // 非即時付款
                    $result .= '紅陽金流交易序號：' . esc_attr($req_data['body']['trade_no']) . '<br>';
                }else{
                    // $result .= '付款方式：' . esc_attr($req_data['body']['card_type']) . '<br>';
                    $result .= '交易失敗，請重新填單<br>錯誤代碼：' . esc_attr($req_data['body']['pay_result']) . '<br>錯誤訊息：' . esc_attr($this->convert_status($req_data['body']['pay_result'])).'<br>';    // 即時付款
                    $result .= '紅陽金流交易序號：' . esc_attr($req_data['body']['trade_no']) . '<br>';
                }
            default:
                // 未來新增之付款方式
                // if ($req_data['pay_status'] == '10') {
                //     $result .= '付款方式：' . esc_attr($req_data['card_type']) . '<br>';
                //     $result .= '交易成功<br>';    // 即時付款
                //     $result .= '紅陽金流交易序號：' . esc_attr($req_data['trade_no']) . '<br>';
                //     break;
                // }
                break;
        }
        if (!empty($req_data['body']['receiver_name']) || !empty($req_data['body']['store_name']) || !empty($req_data['body']['store_id']) || !empty($req_data['body']['store_type'])) {
            // $order_id  = (isset($order_id)) ? $order_id : $req_data['td'];
            $storeType = urldecode($req_data['body']['store_type']); // 門市類型: 1:7-11, 2:全家, 3:OK, 4:萊爾富
            $storeName = urldecode($req_data['body']['store_name']); // 門市名稱
            $storeAddr = urldecode($req_data['body']['store_id']); // 門市編號
            $name      = urldecode($req_data['body']['receiver_name']); // 取貨人姓名
            $phone     = $req_data['body']['receiver_phone'];
            $result .= '<br>取貨人：' . esc_attr($name) . '<br>電話：' . esc_attr($phone) . '<br>店家：' . esc_attr($storeName) . '<br>地址：' . esc_attr($storeAddr) . '<br>';
            $result .= '請等待超商通知取貨<br>';
            if (empty($order->get_meta('_sunpayStoreName'))) {
                $order->update_meta_data('_sunpayStoreType', $storeType);
                $order->update_meta_data('_sunpayStoreName', $storeName);
                $order->update_meta_data('_sunpayStoreAddr', $storeAddr);
                $order->update_meta_data('_sunpayConsignee', $name);
                $order->update_meta_data('_sunpayConsigneePhone', $phone);
                $order->save();
            }
        }

        // echo $result;

        return $result;
    }

    /**
     * //ready to deprecate
     * convert payment_type
     */
    private function get_payment_type_str($payment_type = '')
    {
        $PaymentType_Ary = array(
            '01' => '信用卡',
            '02' => '銀聯卡',
            '03' => 'ApplePay / GooglePay',
            '06' => '超商代碼繳費',
            '07' => '超商條碼繳費',
            '08' => '虛擬帳號',
            '09' => '超商取貨付款',
            '10' => '街口支付',
        );
        $re_str          = (isset($PaymentType_Ary[$payment_type])) ? $PaymentType_Ary[$payment_type] : $payment_type;
        return $re_str;
    }

    /**
     * 接收回傳參數驗證
     *
     * @access public
     * @return void
     */
    public function receive_response()
    {
        $req_data = array();
        if(!isset($_REQUEST['rsamsg']) && isset($_REQUEST['callback']) && $_REQUEST['callback'] == "backToStore"){
            header("Location:".$this->get_return_url());
            exit();
        }

        // 檢查SHA值是否正確 MPG1.4版
        if (!empty(sanitize_text_field($_REQUEST['rsamsg']))) {
            $req_data = $this->sunpayTool->get_decrypted_data(
                sanitize_text_field($_REQUEST['rsamsg']),
                $this->RSAPublicKey,
                $this->SHA2Key
            );
            if (!$this->sunpayTool->chkShaIsVaildByReturnData($_REQUEST, $req_data['check_value'], $this->MerchantID)) {
                echo '檢查碼錯誤';
                exit; // 一定要有離開，才會被正常執行
            }
            if (!is_array($req_data) || 
               (isset($req_data['data']) && !is_array($req_data['data']))) {
                echo '解密失敗';
                exit; // 一定要有離開，才會被正常執行
            }
        }

        // 初始化$req_data 避免因index不存在導致NOTICE 若無傳入值的index將設為null
        $init_indexes_head  = 'send_time,web';
        $head = $this->sunpayTool->init_array_data($req_data['data']['head'],$init_indexes_head);
        $init_indexes_body  = 'approve_code,card_no,card_type,currency,mn,name,note1,note2,pay_agency,pay_agency_memo,
                               pay_date,pay_result,pay_time,td,trade_no,save_card_token_result,user_no';                                                     //付款完成之回傳參數欄位
        $init_indexes_body .= 'delivery_type,store_id,store_name,store_type,lgs_type,receiver_name,receiver_phone';                                          //超商物流之回傳參數欄位
        $init_indexes_body .= 'account_id,account_name,bank_code,banc_name,due_date,pay_code,barcodeA,barcodeB,barcodeC';                                    //取號完成之回傳參數欄位
        $body = $this->sunpayTool->init_array_data($req_data['data']['body'],$init_indexes_body);
        $req_data = array(
            "body" => $body,
            "head" => $head
        );

        $re_MerchantOrderNo = trim($req_data['body']['td']);
        $re_Status  = trim($req_data['body']['pay_result']) != '' ? trim($req_data['body']['pay_result']) : null;
        $re_TradeNo = $req_data['body']['trade_no'];
        $re_Amt     = $req_data['body']['mn'];
        $re_CardType = $req_data['body']['card_type'];
        // echo json_encode($req_data);
        // exit();

        $order = wc_get_order(explode("T", $re_MerchantOrderNo)[0]);
        
        //儲存此次交易結果
        $order->update_meta_data('_sunpayResponseData', json_encode($req_data));
        //儲存紅陽交易編號
        $order->set_transaction_id($req_data['trade_no']);
        //儲存付款方式
        $order->set_payment_method_title($this->method_title. $this->get_payment_type_str($re_CardType));
        $order->save();

        $redirect_url = $this->get_return_url($order);
        if (!$order) {
            echo '取得訂單失敗，訂單編號' . esc_attr($re_MerchantOrderNo);
            exit();
        }
        if (sanitize_text_field($_GET['callback']) == 'frontpage') {
            //前端不執行後續處理
            header("Location:".$redirect_url);
            exit();
        }

        $Amt = round($order->get_total());
        if ($order->is_paid()) {
            echo '訂單已付款';
            exit(); // 已付款便不重複執行
        }

        // 檢查回傳狀態是否為成功
        if ($re_Status != "10") {
            $msg = '訂單處理失敗: ';
            if($re_Status == "12" && $re_CardType == "09"){
                //超商取貨另外處理
                $msg = "訂單已建立,等待付款";
                $order->update_status('pending');
                $order->add_order_note($msg);
            }else{
                if($re_Status == "12" && str_contains("06,07,08",$re_CardType)){
                    //非即時性付款
                    $msg = "訂單已建立,等待付款";
                    $order->update_status('pending');
                    $order->add_order_note($msg);
                }else if($re_Status == "11"){
                    $msg .= "交易失敗";
                    $order->update_status('cancelled');
                }else if($re_Status == "12"){
                    $msg .= "訂單已建立過";
                    $order->update_status('cancelled');
                }
                $order->add_order_note($msg);
                echo esc_attr($msg);
                exit();
            }
        }

        // 檢查是否付款
        // if (empty($req_data['body']['pay_time'])) {
        //     $msg = '訂單並未付款';
        //     $order->update_status('cancelled');
        //     echo esc_attr($msg);
        //     exit; // 一定要有離開，才會被正常執行
        // };

        // 檢查金額是否一樣
        if ($Amt != $re_Amt) {
            $msg = '金額不一致';
            $order->update_status('cancelled');
            echo esc_attr($msg);
            exit();
        }

        // 訂單備註
        $note_text  = '<<<code>紅陽金流</code>>>';
        $note_text .= '</br>商店訂單編號：' . $re_MerchantOrderNo;
        $note_text .= '</br>紅陽金流支付方式：' . $this->get_payment_type_str($re_CardType);
        $note_text .= '</br>紅陽金流交易序號：' . $re_TradeNo;
        $order->add_order_note($note_text);

        // 非即時性付款(超商取貨付款另外處理)
        if(str_contains("06,07,08",$re_CardType)){
            try{
                // 檢查是否付款
                if (empty($req_data['body']['pay_date']) || empty($req_data['body']['pay_time'])) {
                    $msg = '訂單並未付款';
                    $order->update_status('cancelled');
                    echo esc_attr($msg);
                    exit; // 一定要有離開，才會被正常執行
                }
            }catch(Exception $e){
                $note_text  = '<<<code>紅陽金流</code>>>';
                $note_text .= '</br>處理'.$this->get_payment_type_str($re_CardType).'失敗';
                $note_text .= '</br>錯誤訊息:' . $e->getMessage();
                $order->add_order_note($note_text);
            }            
        }
        // 超商取貨
        if (!empty($req_data['body']['receiver_name']) || !empty($req_data['body']['store_name']) || !empty($req_data['body']['store_id']) || !empty($req_data['body']['store_type'])) {
            $storeType = urldecode($req_data['body']['store_type']); // 門市類型: 1:7-11, 2:全家, 3:OK, 4:萊爾富
            $storeName = urldecode($req_data['body']['store_name']); // 門市名稱
            $storeId = urldecode($req_data['body']['store_id']); // 門市編號
            $name      = urldecode($req_data['body']['receiver_name']); // 取貨人姓名
            $phone     = $req_data['body']['receiver_phone'];
            $order->update_meta_data('_sunpayStoreType', $storeType);
            $order->update_meta_data('_sunpayStoreName', $storeName);
            $order->update_meta_data('_sunpayStoreAddr', $storeId);
            $order->update_meta_data('_sunpayConsignee', $name);
            $order->update_meta_data('_sunpayConsigneePhone', $phone);
            $order->save();
            // 訂單備註
            $note_text  = '<<<code>紅陽金流</code>>>';
            $note_text .= '</br>取貨門市：' . $storeName;
            $note_text .= '</br>取貨門市ID：' . $storeId;
            $note_text .= '</br>取貨人姓名：' . $name;
            $note_text .= '</br>取貨人電話：' . $phone;
            $order->add_order_note($note_text);
        }

        if (!empty($req_data['body']['pay_date']) && !empty($req_data['body']['pay_time'])) {
            //寫入付款時間
            $paid_date = date("Y/m/d",strtotime($req_data['body']['pay_date'])) . " " . $req_data['body']['pay_time'];
            $order->set_date_paid(strtotime($paid_date));
            $note_text  = '<<<code>紅陽金流</code>>>';
            $note_text .= '</br>付款成功';
            $note_text .= '</br>付款時間:' . $paid_date;
            $order->add_order_note($note_text);

            // 全部確認過後，修改訂單狀態(處理中，並寄通知信)
            $order->update_status('processing');
            $msg   = '訂單修改成功';

            if ($this->eiEnable == 'yes') {
                $this->ei->electronic_invoice($order, $re_TradeNo);
            }
        }

        if (sanitize_text_field($_GET['callback']) != '') {
            if($_GET['callback'] == "return"){
                echo "success";
                return "success";
            }else{
                echo esc_attr($msg);
                header("Location:".$redirect_url);
            }
            exit; // 一定要有離開，才會被正常執行
        }
    }

    /**
     * Generate the sunpay button link (POST method)
     *
     * @access public
     * @param mixed $order_id
     * @return string
     */
    public function generate_sunpay_form($order_id)
    {
        $order               = wc_get_order($order_id);
        $sunpay_args       = $this->get_sunpay_args($order);
        $sunpay_gateway    = $this->gateway;
        $sunpay_args_array = array();
        foreach ($sunpay_args as $key => $value) {
            $sunpay_args_array[] = '<input type="hidden" name="' . esc_attr($key) . '" value="' . esc_attr($value) . '" />';
        }

        return '<form id="sunpay" name="sunpay" action="' . $sunpay_gateway . '" method="post" target="_top">' . implode('', $sunpay_args_array) . '
            <input type="submit" class="button-alt" id="submit_sunpay_payment_form" value="' . __('前往 紅陽金流 支付頁面', 'sunpay') . '" />
            </form>' . "<script>setTimeout(\"document.forms['sunpay'].submit();\",\"10000\")</script>";
    }

    /**
     * Check the payment method and the chosen payment
     */
    public function validate_fields()
    {
        $choose_payment = sanitize_text_field($_POST['sunpay_selected_payments']);
        $is_use_sunship = isset($_POST['use_sunship']) ? true : false;
        if ($_POST['payment_method'] == $this->id) {
            $this->sunpaySelectedPayment = $choose_payment;
            $this->useSunship = $is_use_sunship;
            return true;
        } else {
            return false;
        }
    }

    /**
     * Output for the order received page.
     *
     * @access public
     * @return void
     */
    public function receipt_page($order)
    {
        echo '<p>' . '10秒後會自動跳轉到紅陽金流支付頁面，或者按下方按鈕直接前往<br>' . '</p>';
        echo $this->generate_sunpay_form(esc_attr($order));
    }

    /**
     * Process the payment and return the result
     *
     * @access public
     * @param int $order_id
     * @return array
     */
    public function process_payment($order_id)
    {
        global $woocommerce;
        $order = wc_get_order($order_id);
        $order->save();
        $note_str = $this->sunpaySelectedPayment;
        $note_str .= $this->useSunship ? ",useSunship" : "";
        $order->add_order_note($note_str, 1);
        // $order->add_order_note($this->useSunship, 0);
        return array(
            'result'   => 'success',
            'redirect' => $order->get_checkout_payment_url(true),
        );
    }

    /**
     * Payment form on checkout page
     *
     * @access public
     * @return void
     */
    public function payment_fields()
    {
        echo $this->get_show_data();
    }

    /**
     * show selected payment method on checkout page
     */
    private function get_show_data()
    {
        $payment_method = $this->get_selected_payment();
        $use_sunship = '';
        $szHtml         = '';
        $szHtml        .= '付款方式 : ';
        $szHtml        .= '<select name="sunpay_selected_payments" onChange="paymentMethodChange(this)">';
        foreach ($payment_method as $payment_method => $value) {
            if ($payment_method == 'SunShipWithPay') {
                $use_sunship = 1;
                continue;
            }
            $szHtml .= '<option value="' . esc_attr($payment_method) . '">';
            $szHtml .= esc_html($this->convert_payment($payment_method));
            $szHtml .= '</option>';
        }
        $szHtml .= '</select>';
        if ($use_sunship == 1) {
            $szHtml .= '<br><input type="checkbox" name="use_sunship" id="use_sunship" /><label for="use_sunship">超商取貨不付款</label>';
        }
        return $szHtml;
    }

    /**
     * wcBlocksRegistry
     */
    public function wcBlocksRegistry($registry)
    {
        $registry->registerBlockType(
            'sunpay/payment',
            array(
                'render_callback' => array($this, 'wcBlocksRenderCallback'),
            )
        );
    }

    /**
     * convert payment type
     */
    private function convert_payment($payment_method)
    {
        $method = array(
            'BuySafe'    => '信用卡一次付清',
            'buysafemul' => '信用卡分期',
            // 'GooglePay'  => 'Google Pay',
            // 'ApplePay'   => 'Apple Pay',
            'GooglePayAndApplePay'   => 'Google Pay/Apple Pay',
            'UnionPay'   => '銀聯卡',
            // 'WebATM'     => '網路ATM轉帳',
            'Atm'        => '虛擬帳號',
            '24Pay'      => '超商條碼繳費',
            'PayCode'    => '超商代碼繳費',
            'JkoPay'     => '街口支付',
            'SunShip'    => '超商取貨付款',
        );


        return $method[$payment_method];
    }

    private function convert_payment_method_to_code($payment_method){
        $method = array(
            'BuySafe'    => '01',
            'buysafemul' => '01',
            // 'GooglePay'  => '03',
            // 'ApplePay'   => '03',
            'GooglePayAndApplePay'  => '03',
            'UnionPay'   => '02',
            // 'WebATM'     => '08',
            'Atm'        => '08',
            '24Pay'      => '06',
            'PayCode'    => '07',
            'JkoPay'     => '10',
            'SunShip'    => '09',
        );

        if(isset($method[$payment_method])){
            return $method[$payment_method];
        }else{
            return $payment_method;
        }   
    }

    private function convert_status($pay_status){
        $status = array(
            "10" => "交易成功",
            "11" => "交易失敗",
            "12" => "無此交易",
            "13" => "交易未完成",
            "14" => "訂單退款",
            "15" => "交易取消",
        );

        if(isset($status[$pay_status])){
            return $status[$pay_status];
        }else{
            return $pay_status;
        }        
    }

    /**
     *  get comsumer selected payment method
     */
    private function get_selected_payment()
    {
        $payment_method = array();

        foreach ($this->settings as $row => $value) {
            if (str_contains($row, 'SunpayPaymentMethod') && $value == 'yes') {
                $payment_method[str_replace('SunpayPaymentMethod', '', $row)] = 1;
            }
        }

        return $payment_method;
    }

    /**
     * admin field, show check transaction status button on admin's order page
     */
    public function admin_other_field($order)
    {
        $order_id = $order->get_id();

        $payment_method = $order->get_payment_method();

        if ($payment_method == 'sunpay') {
            // echo '<button id="checkSunpayOrder" data-value="' . $order_id . '">至紅陽更新交易狀態</button>';
            // echo '<button id="testButton" data-value="' . $order_id . '">測試用</button>';

            // 引用js
            // wp_enqueue_script(
            //     'paymentCheck',
            //     plugins_url('assets/js/admin/sunpayAdminAjax.js', dirname(dirname(__FILE__))),
            //     array('jquery')
            // );
        }
    }
}
