<?php

/**
 * sunpay API
 */
class sunpayOthersAPI extends WC_sunpay
{

	public $cardRefund;

	/**
	 * construct
	 */
	public function __construct()
	{
        $this->id  = 'sunpay';
        // Load the settings.
        $this->init_settings();

		$this->MerchantID   = trim($this->get_option('web_value'));
		$this->RSAPublicKey = trim($this->get_option('web_rsa_public_key'));
		$this->SHA2Key      = trim($this->get_option('web_sha2_key'));
		$this->TestMode     = $this->get_option('test_mode');

		$this->paymentCheck  = ($this->TestMode == 'yes') ? 'https://testtrade.sunpay.com.tw/v4/query/PaymentCheck' : 'https://trade.sunpay.com.tw/v4/query/PaymentCheck';
		$this->cardRefund = ($this->TestMode == 'yes') ? 'https://testtrade.sunpay.com.tw/v3/Service/CardRefund' : 'https://trade.sunpay.com.tw/v3/Service/CardRefund';

		$this->sunpayTool = sunpayTool::get_instance();

		// ajax actions
		add_action('wp_ajax_sunpay_track_order', array($this, 'check_order_status'));
		add_action('woocommerce_order_refunded', array($this, 'credit_close_refund'));
	}

	/**
	 * check order status
	 */
	public function check_order_status()
	{
		$data = sanitize_text_field($_POST['value']);

		$order = wc_get_order($data);

		// 查詢交易API
		$result = $this->payment_check($data);

		if (!empty($result) && isset($result['code']) && $result['code'] == "00" && isset($result['result']) && count($result['result']) > 0) {
			$order_info = $result['result'][0];
			$init_indexes_body  = "code,errorMsg,currency,mn,trade_no,td,pay_result,pay_date,pay_time,refund_status,refund_amt,card_no,approve_code,installment,first_amt,install_amt,invoice_no";//查詢之回傳參數欄位
			$order_info = $this->sunpayTool->init_array_data($order_info,$init_indexes_body);

			switch ($order_info['pay_result']) {
				case '10':
					$order->payment_complete($data);
					$status = '交易狀態:交易成功';

					$note_text  = '<<<code>紅陽金流</code>>>';
					$note_text .= '</br>商店訂單編號：' . $data;
					$note_text .= '</br>藍新金流支付方式：' . $this->get_payment_type_str($order_info['card_type']);
					$note_text .= '</br>紅陽金流交易序號：' . $order_info['trade_no'];
					$order->add_order_note($note_text);

					break;
				case '11':
					$status = '交易狀態:交易失敗';
					break;

				case '12':
					$status = '交易狀態:無此交易';
					break;

				case '13':
					$status = '交易狀態:交易未完成';
					break;

				case '14':
					$status = '交易狀態:訂單退款';
					break;

				case '15':
					$status = '交易狀態:交易取消';
					break;
			}

			$echo_str = '紅陽金流交易序號:' . esc_attr($order_info['trade_no']) . PHP_EOL .
				'商店支付方式:' . esc_attr($this->get_payment_type_str($order_info['card_type'])) . PHP_EOL . $status;
		} else {
			$echo_str = isset($result['msg']) ? trim($result['msg']) : "查詢失敗";
		}

		wp_die($echo_str);
	}

	private function get_payment_type_str($payment_type = '')
	{
        $PaymentType_Ary = array(
            '01' => '信用卡',
            '02' => '銀聯卡',
            '03' => 'ApplePay / GooglePay',
            '06' => '超商代碼繳費',
            '07' => '超商條碼繳費',
            '08' => '虛擬帳號',
            '09' => '超商取貨付款',
            '10' => '街口支付',
        );
        $re_str          = (isset($PaymentType_Ary[$payment_type])) ? $PaymentType_Ary[$payment_type] : $payment_type;
        return $re_str;
	}   
	
	private function get_pay_result_str($pay_status){
        $status = array(
            "10" => "交易成功",
            "11" => "交易失敗",
            "12" => "無此交易",
            "13" => "交易未完成",
            "14" => "訂單退款",
            "15" => "交易取消",
        );

        if(isset($status[$pay_status])){
            return $status[$pay_status];
        }else{
            return $pay_status;
        }        
    }

	/**
	 * close the credit transaction (refund)
	 */
	public function credit_close_refund()
	{
		foreach ($_POST as $key => $value) {
			$data[$key] = sanitize_text_field($value);
		}

		$order_id = $data['order_id'];

		$order  = wc_get_order($order_id);   // 原$_REQUEST['order-received']

		$result = $this->payment_check($order_id);
		
		if (!empty($result) && isset($result['code']) && $result['code'] == "00" && isset($result['result']) && count($result['result']) > 0) {
			$order_info = $result['result'][0];
			$init_indexes_body  = "code,errorMsg,currency,mn,trade_no,td,pay_result,pay_date,pay_time,refund_status,refund_amt,card_no,approve_code,installment,first_amt,install_amt,invoice_no";//查詢之回傳參數欄位
			$order_info = $this->sunpayTool->init_array_data($order_info,$init_indexes_body);

			$payment_type  = $order_info['card_type'];
			$refund_status  = $order_info['refund_status'];
			$refund_amount = $data['refund_amount'];
			$refund_memo = $data['refund_reason'];
			if(empty($refund_memo)){
				$refund_memo = "訂單退款";
			}

			$note_text  = '<<<code>紅陽金流信用卡退款</code>>>';
			$note_text .= '</br>商店訂單編號：' . $order_id;
			$note_text .= '</br>紅陽金流交易序號：' . $order_info['trade_no'];

			// if($order_info['pay_result'] != "10" || $order_info['pay_result'] != "14"){
			// 	return "此訂單狀態為 ".$this->get_pay_result_str($order_info['pay_result'])." ,不可退款"
			// }
			// if(is_numeric($order_info['refund_amt']) && $refund_amount > $order_info['refund_amt']){
			// 	return "退款金額不可超過 ".$order_info['refund_amt']." 元";
			// }
			// if (str_contains("01,02,03,10",$payment_type)) {

			// 	switch ($refund_status) {
			// 		case '0':
			// 			//未退款
			// 		case '3':
			// 			//退款失敗
			// 		case '4':
						//取消退款
				$respondDecode = $this->refund_trade($order_info, $refund_amount, $refund_memo);

				if ($respondDecode['code'] == '20') {
					$note_text .= '</br>本次退款金額：' . $refund_amount . '</br>退款狀態:退款請求成功';
					$order->update_status('wc-refunded', 'order_note');
				} else {
					$note_text .= '</br>本次退款金額：' . $refund_amount . '</br>退款狀態:退款請求失敗,錯誤代碼' . $respondDecode['code'] . '</br>錯誤訊息:'.$respondDecode['msg'].'</br>請至紅陽官網查詢';
				}

				// 		break;
				// 	case '1':
				// 		$note_text .= '</br>本次交易退款處理中';
				// 		break;
				// 	case '2':
				// 		$note_text .= '</br>本次交易已退款';
				// 		break;
				// }
				$order->add_order_note($note_text);

				return $respondDecode;
			// }else{
			// 	return $this->get_payment_type_str($payment_type)." 不支援退款";
			// }
		}else{
			return "查無此訂單";
		}

	}

	/**
	 * call sunpay paymentCheck api
	 */
	private function payment_check($order_id)
	{
		$api_url = $this->paymentCheck;
		$order = wc_get_order($order_id);
		$merchant_order_no = $order->get_meta('_sunpayMerchantOrderNo');

        //取得send_time
        $sendTime = $this->sunpayTool->get_send_time();
        
        $head = array(
            "web" => $this->MerchantID,
			"send_time" => $sendTime,
        );

        $body[] = array(
            "td" => $merchant_order_no,
        );

        $data = array(
            "body" => $body,
            "head" => $head,
        );

        $encrypted_data = $this->sunpayTool->get_encrypted_data($data, $this->RSAPublicKey, $this->SHA2Key);

        $rsamsg    = $encrypted_data['rsamsg'];
        $check_value = $encrypted_data['check_value'];

        $post_data = array(
            "web" => $this->MerchantID,
            "send_time" => $sendTime,
            "rsamsg" => $rsamsg,
            "check_value" => $check_value
        );

		// curl 結果
		$result = $this->curl_(json_encode($post_data), $api_url);
		$respondDecode = json_decode($result['web_info'], true);

		return $respondDecode;
	}

	private function refund_trade($order_info, $refund_amt, $refund_memo){

		$api_url = $this->cardRefund;

        //取得send_time
        $sendTime = $this->sunpayTool->get_send_time();
        
        $head = array(
            "web" => $this->MerchantID,
			"send_time" => $sendTime,
        );

        $body = array(
			"card_type" => $order_info["card_type"],
			"currency" => $order_info["currency"],
			"mn" => $refund_amt,
			"refund_memo" => $refund_memo,
            "td" => $order_info["td"],
			// "trade_no" => $order_info["trade_no"],
        );

        $data = array(
            "body" => $body,
            "head" => $head,
        );

        $encrypted_data = $this->sunpayTool->get_encrypted_data($data, $this->RSAPublicKey, $this->SHA2Key);

        $rsamsg    = $encrypted_data['rsamsg'];
        $check_value = $encrypted_data['check_value'];

        $post_data = array(
            "web" => $this->MerchantID,
            "send_time" => $sendTime,
            "rsamsg" => $rsamsg,
            "check_value" => $check_value
        );

		// curl 結果
		$result = $this->curl_(json_encode($post_data), $api_url);
		$respondDecode = json_decode($result['web_info'], true);

		return $respondDecode;
	}

	//curl 函式
	private function curl_($curl_str = '', $curl_url)
	{
		// //curl init
		// $ch = curl_init();
		// //curl set option
		// curl_setopt($ch, CURLOPT_URL, $curl_url);
		// curl_setopt($ch, CURLOPT_POST, 1);
		// curl_setopt($ch, CURLOPT_POSTFIELDS, $curl_str);
		// curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		// 	'Content-Type: application/json',
		// 	'Content-Length: ' . strlen($curl_str))
		// );
		// curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		// curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, TRUE);
		// curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, TRUE);
		// curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
		// //execute
		// $result = curl_exec($ch);
		// $retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		// $curl_error = curl_errno($ch);
		// //close
		// curl_close($ch);
		$requestAry = array(
			'body'        => $curl_str,
			'headers'     => [
				'Content-Type' => 'application/json',
			],
			'timeout'     => 60,
			'redirection' => 5,
			'blocking'    => true,
			'httpversion' => '1.0',
			'sslverify'   => true,
			'data_format' => 'body',
		);

		$result                 = wp_remote_post( $curl_url, $requestAry ); // 背景送出

		$return_array = [
			'url' => $curl_url,
			'send_parameter' => $curl_str,
			// 'http_status' => $retcode,
			// 'curl_error_no' => $curl_error,
			'web_info' => $result['body']
		];

		return $return_array;
	}
}

new sunpayOthersAPI();
