function identifierchk(identifier) {
	var tmp = new String( "12121241" );
	var sum = 0;
	re      = /^\d{8}$/;
	if ( ! re.test( identifier )) {
		return false;
	}

	for (i = 0; i < 8; i++) {
		s1   = parseInt( identifier.substr( i, 1 ) );
		s2   = parseInt( tmp.substr( i, 1 ) );
		sum += cal( s1 * s2 );
	}

	if ( ! valid( sum )) {
		if (identifier.substr( 6, 1 ) == "7") {
			return (valid( sum + 1 ));
		}
	}

	return (valid( sum ));
}

function valid(n) {
	return (n % 10 == 0) ? true : false;
}

function validCarrierId(type, value){
	var valid = false;
	switch(type){
		case "1":
			//手機條碼
			var regexp = /^\/[0-9A-Z\+\-\.]{7}$/;
			if (regexp.test(value)){
				valid = true;
			}
			break;
		case "2":
			//自然人憑證條碼
			var regexp = /^[A-Z]{2}[0-9]{14}$/;
			if (regexp.test(value)){
				valid = true;
			}
			break;
		case "4":
			//捐贈碼
			var regexp = /^[0-9]{3,7}$/;
			if (regexp.test(value)){
				valid = true;
			}
			break;
		default:
			console.log("default");
			valid = true;
			break;
	}
	return valid;
}

function cal(n) {
	var sum = 0;
	while (n != 0) {
		sum += (n % 10);
		n    = (n - n % 10) / 10;
	}
	return sum;
}

function UBNrog() {
	var valid     = false;
	var tof     = false;
	var needUBN = jQuery( "#billing_needUBN" ).val();
	var UBNval  = jQuery( "#billing_UBN" ).val();
	if (needUBN == 1) {
		jQuery( "#carrierIdDvi" ).css( "display", "inline" );
		jQuery( "#carrierIdDivAlert" ).css( "display", "none" );
		tof = identifierchk( UBNval );
		if (tof == true) {
			valid = true;
		} else {
			valid = false;
		}
	} else {
		// jQuery( "#ifDivAlert" ).css( "display", "none" );
		jQuery( "#billing_UBN" ).val( "" );
		jQuery( "#billing_Buyer" ).val( "" );
		valid = true
	}

	if (!valid) {
		jQuery( "#UBNdivAlert" ).css( "display", "inline" );
		if (jQuery( "#billing_UBN" ).val().length == 0) {
			jQuery( "#UBNdivAlert" ).html( "&nbsp&nbsp請輸入統一編號!!!" );
		} else {
			jQuery( "#UBNdivAlert" ).html( "&nbsp&nbsp格式錯誤!!!" );
		}
		jQuery( "#place_order" ).attr( "disabled", true );
		jQuery( "#place_order" ).css( "background-color", "red" );
	} else {
		jQuery( "#UBNdivAlert" ).css( "display", "none" );
		jQuery( "#place_order" ).attr( "disabled", false );
		jQuery( "#place_order" ).css( "background-color", "#111111" );
	}
}

function eiCarrierTypeChk() {
	var ifVal = jQuery( "#billing_carrierType" ).val();
	identifierOrCarrier();
	jQuery( "#billing_carrierId1" ).val( "" );
	jQuery( "#billing_carrierId1" ).attr( "disabled", false );
	if (ifVal == 0) {
		jQuery( "#carrierIdDiv" ).css( "display", "none" );
	} else if (ifVal == 1) {
		jQuery( "#carrierIdLabel" ).html( "載具號碼" );
		jQuery( "#billing_carrierId1" ).attr( "placeholder", "請輸入手機條碼" );
	} else if (ifVal == 2) {
		jQuery( "#carrierIdLabel" ).html( "載具號碼" );
		jQuery( "#billing_carrierId1" ).attr( "placeholder", "請輸入自然人憑證條碼" );
	} else if (ifVal == 4) {
		jQuery( "#carrierIdLabel" ).html( '捐贈碼<a href="https://www.einvoice.nat.gov.tw/portal/btc/btc603w/search" target="_blank" style="padding-left: 5px;font-size: 16px;">查詢捐贈碼</a>' );
			jQuery( "#billing_carrierId1" ).attr( "placeholder", "請輸入受捐單位捐贈碼" );
	} else {
		jQuery( "#carrierIdLabel" ).html( "載具號碼" );
		jQuery( "#billing_carrierId1" ).attr( "placeholder", "電子發票通知將寄送至您的電子郵件地址" );
		jQuery( "#billing_carrierId1" ).attr( "disabled", true );
	}
	eiCarrierId1Chk();
}

function eiCarrierId1Chk() {
	var carrierIdVal  = jQuery( "#billing_carrierId1" ).val();
	var carrierTypeVal   = jQuery( "#billing_carrierType" ).val();
	var needUBN = jQuery( "#billing_needUBN" ).val();
	if (needUBN == 0) {
		if (carrierIdVal || carrierTypeVal == 0) {
			if(validCarrierId(carrierTypeVal, carrierIdVal)){
				jQuery( "#carrierIdDivAlert" ).css( "display", "none" );
				jQuery( "#place_order" ).attr( "disabled", false );
				jQuery( "#place_order" ).css( "background-color", "#111111" );
			}else{
				jQuery( "#carrierIdDivAlert" ).css( "display", "" );
				jQuery( "#place_order" ).attr( "disabled", true );
				jQuery( "#place_order" ).css( "background-color", "red" );
				jQuery( "#carrierIdDivAlert" ).html( "格式錯誤" );
			}
		} else {
			jQuery( "#carrierIdDivAlert" ).css( "display", "" );
			jQuery( "#place_order" ).attr( "disabled", true );
			jQuery( "#place_order" ).css( "background-color", "red" );
			if (carrierTypeVal == 4) {
				jQuery( "#carrierIdDivAlert" ).html( "請輸入捐贈碼" );
			} else if(carrierTypeVal == 3) {
				jQuery( "#place_order" ).attr( "disabled", false );
				jQuery( "#place_order" ).css( "background-color", "#111111" );
				jQuery( "#carrierIdDivAlert" ).html( "" );
			} else{
				jQuery( "#carrierIdDivAlert" ).html( "請輸入載具號碼" );
			}
		}
	}
}

jQuery( document ).ready(
	function () {
		identifierOrCarrier();
		jQuery( "#billing_UBN" ).attr( "maxlength", "8" );
		jQuery( "#billing_carrierId1" ).attr( "disabled", true );
		jQuery( "#billing_UBN" ).keyup(
			function () {
				UBNrog();
				if (jQuery( "#billing_UBN" ).val().length < 8) {
					jQuery( "#UBNdivAlert" ).css( "display", "none" );
				}
				eiCarrierTypeChk();
			}
		);

		jQuery( "#billing_UBN" ).change(
			function () {
				UBNrog();
				eiCarrierTypeChk();
			}
		);

		jQuery( "#billing_UBN" ).bind(
			"paste",
			function () {
				setTimeout(
					function () {
						UBNrog();
					},
					100
				);
				eiCarrierTypeChk();
			}
		);

		jQuery( "#billing_carrierType" ).change(
			function () {
				eiCarrierTypeChk();
			}
		);

		jQuery( "#billing_carrierId1" ).keyup(
			function () {
				eiCarrierId1Chk();
			}
		);

		jQuery( "#billing_needUBN" ).change(
			function () {
				setTimeout(
					function () {
						UBNrog();
						identifierOrCarrier();
						jQuery( "#billing_carrierType" ).trigger("change")
					},
					100
				);
			}
		);

		jQuery( "#billing_carrierId1" ).css( "width", "100%" );
		jQuery( "#billing_carrierType" ).trigger("change")
	}
);

function identifierOrCarrier() {
	if (jQuery( "#billing_needUBN" ).val() == 1) {
		jQuery( "#identifierDiv" ).css( "display", "" );
		jQuery( "#carrierTypeDiv" ).css( "display", "none" );
		jQuery( "#carrierIdDiv" ).css( "display", "none" );
	} else {
		jQuery( "#identifierDiv" ).css( "display", "none" );
		jQuery( "#carrierTypeDiv" ).css( "display", "" );
		if(jQuery( "#billing_carrierType" ).val() == 0){
			jQuery( "#carrierIdDiv" ).css( "display", "none" );
		}else{
			jQuery( "#carrierIdDiv" ).css( "display", "" );
		}
	}
}
