<?php


namespace Opencart\Catalog\Controller\Extension\SunpayPayment\Payment;

class sunpayElectronicInvoice {

	private $sunpayTool;
	private $eiEnable;
    private $TestMode;
	private $companyID;
	private $merchantID;
	private $HashKey;
	private $HashIV;
	private $taxType;
	private $taxRate;
	private $IsSendMessage;
	private $IsSendPaper;

	private static $instance;

	/**
	 * Returns the *Singleton* instance of this class.
	 *
	 * @return Singleton The *Singleton* instance.
	 */
	public static function get_instance( $invData = array() ) {
		if ( null === self::$instance ) {
			self::$instance = new self( $invData );
		}
		return self::$instance;
	}

	protected function __construct( $invData = array() ) {
		$this->eiEnable      = $invData['eiEnable'];
		$this->companyID     = $invData['companyID'];
		$this->merchantID    = $invData['merchantID'];
		$this->HashKey       = $invData['HashKey'];
		$this->HashIV        = $invData['HashIV'];
		$this->IsSendMessage = intval($invData['IsSendMessage']);
		$this->IsSendPaper   = $invData['IsSendPaper'];
		$this->taxType       = intval($invData['taxType']);
		$this->taxRate       = $invData['taxRate'];
		$this->TestMode      = $invData['testMode'];

		$this->sunpayTool = sunpayTool::get_instance();
	}

	function electronic_invoice( $order_id, $tradeNo, $order, $products, $inv_data ) {

		$CompanyID  = $this->companyID; // 商店統一編號
		$MerchantID = $this->merchantID; // 商店代號
		$key        = $this->HashKey;  // 商店專屬串接金鑰HashKey值
		$iv         = $this->HashIV;  // 商店專屬串接iv

		$buyerNeedUBN = !empty($inv_data['INV_UBN']);
		if ( $buyerNeedUBN ) {
			$buyerUBN    = $inv_data['INV_UBN'];
			$eiType    = 'B2B';
			$carrierType = intval($inv_data['CARRIER_TYPE']);
		} else {
			$buyerUBN    = '';
			$eiType    = 'B2C';
			$carrierType = intval($inv_data['CARRIER_TYPE']);
		}

		$productItems = array();
		$item_cnt = 0;
		//組合商品資料
		foreach ( $products as $_ind => $product ) {
			$productItems[] = array(
				"description" => $product['name'],
				"quantity" => $product['quantity'],
				"unit" => "個",
				"unitPrice" => ceil($product['price']),
				"amount" => ceil($product['price']) * $product['quantity'],
				"remark" => "",
				"taxType" => null,
			);			

			$item_cnt++;
		}

		if ( ! $this->chkOrderEiTypeisValid( $order, $eiType ) ) {
			$msg = '發票開立失敗，錯誤訊息：' . '無法取得訂單資訊';
			$this->writeLog($msg);
			return array();
		}

		//運費
		// if ( $order->get_total_shipping() > 0 ) {
		// 	$productItems[] = array(
		// 		"description" => $order->get_shipping_method(),
		// 		"quantity" => "1",
		// 		"unit" => "個",
		// 		"unitPrice" => $this->getShippingPriceByEiType( $order, $eiType ),
		// 		"amount" => $this->getShippingPriceByEiType( $order, $eiType ),
		// 		"remark" => "",
		// 		"taxType" => null,
		// 	);			
		// }

		// if ( $discount_with_tax > 0 ) {
		// 	$productItems[] = array(
		// 		"description" => "折扣",
		// 		"quantity" => "1",
		// 		"unit" => "次",
		// 		"unitPrice" => $discount_with_tax,
		// 		"amount" => $discount_with_tax,
		// 		"remark" => "",
		// 		"taxType" => null,
		// 	);			
		// }

		$totalAmt = round( $this->getTotalAmount($products) );

		$salesAmt = 0; //round($totalAmt / (1+$taxRate));
		$zeroAmt = 0;
		$freeAmt = 0;
		$customsClearanceMark = 0;
		$zeroTaxRateReason = null;
		$taxType          = $this->taxType;

		switch ( $taxType ) {
			case 1:
				$invoiceType = 7;
				$taxRate = 0.05;
				$salesAmt = round($totalAmt / (1+$taxRate));
				break;
			case 2.1:
				$taxType          = 2;
				$taxRate = 0;
				$invoiceType = 7;
				$customsClearanceMark = 1;
				$zeroAmt = round($totalAmt / (1+$taxRate));
				$zeroTaxRateReason = 71;
				break;
			case 2.2:
				$taxType          = 2;
				$taxRate = 0;
				$invoiceType = 7;
				$customsClearanceMark = 2;
				$zeroAmt = round($totalAmt / (1+$taxRate));
				$zeroTaxRateReason = 71;
				break;
			case 3:
				$invoiceType = 7;
				$taxRate = 0;
				$freeAmt = round($totalAmt / (1+$taxRate));
				break;
			case 4:
				$taxRate = $this->taxRate;
				$invoiceType = 8;
				$salesAmt = round($totalAmt / (1+$taxRate));
				break;
			case 9:
				$taxRate = null;
				$invoiceType = 7;
				$zeroTaxRateReason = 71;
				$salesAmt = round($totalAmt / (1+$taxRate));
				break;
		}

		// B2B可輸入買受人名稱 若無輸入就使用帳單的姓名(B2C直接用這個)
		$buyerName    = $order['firstname'] . ' ' . $order['lastname'];
		$buyerEmail   = $order['email'];
		$buyerAddress = $order['payment_country'] . $order['payment_postcode'] . $order['payment_city'] . $order['payment_address_1'] . $order['payment_address_2'];
		$buyerPhone   = $order['telephone'];

		$carrierId = $inv_data['CARRIER_NUM'];

		switch ( $carrierType ) {
			case 0:
				//無載具
				$IsSendPaper = $this->IsSendPaper;
				// $carrierType = 0;
				$carrierId1  = null;
				$donateMark  = 0;
				$poban       = null;
				break;
			case 1:
				//手機條碼載具
				$IsSendPaper = 0;
				// $carrierType = 1;
				$carrierId1  = $carrierId;
				$donateMark  = 0;
				$poban       = null;
				break;
			case 2:
				//自然人憑證條碼載具
				$IsSendPaper = 0;
				// $carrierType = 2;
				$carrierId1  = $carrierId;
				$donateMark  = 0;
				$poban       = null;
				break;
			case 3:
				//紅陽會員載具
				$IsSendPaper = 0;
				// $carrierType = 3;
				$carrierId1  = null;
				$donateMark  = 0;
				$poban       = null;
				break;
			case 4:
				//捐贈發票
				$IsSendPaper = 0;
				$carrierType = 0;
				$carrierId1  = "";
				$donateMark  = 1;
				$poban       = $carrierId;
				break;
			default:
				//無載具
				$IsSendPaper = 0;
				$carrierType = 0;
				$carrierId1  = null;
				$donateMark  = 0;
				$poban       = null;
				break;
		}

		//API交易檢查碼
		$nowTimestamp = time();
		$tokenData = array(
			"CompanyID" => $CompanyID,
			// "TimeStamp" => strval($nowTimestamp),
			"TimeStamp" => strval(strtotime("+8 hours", $nowTimestamp)),
		);
		$tokenDataJson = json_encode($tokenData);
		$token = $this->sunpayTool->aesEncrypt(urlencode($tokenDataJson), $key, $iv);

		if($eiType == "B2B"){
			//B2B
			if ( $this->TestMode ) {
				$url = 'https://testinv.sunpay.com.tw/api/v1/SunPay/CreateInvoiceb2b'; // 測試網址
			} else {
				$url = 'https://einv.sunpay.com.tw/api/v1/SunPay/CreateInvoiceb2b'; // 正式網址
			}
			$post_data_array = array( // post_data欄位資料
				'merchantID'           => $MerchantID,
				'orderNo'              => $order_id,
				'buyerIdentifier'      => $buyerUBN,
				'buyerName'            => $buyerName,
				'buyerEmailAddress'    => $buyerEmail,
				'IsSendMessage'        => $this->IsSendMessage,
				'buyerTelephoneNumber' => $buyerPhone,
				'IsSendPaper'          => $IsSendPaper,
				'buyerAddress'         => $buyerAddress,
				'invoiceType'          => $invoiceType,
				'taxType'              => $taxType,
				'taxRate'        	   => $taxRate,
				'taxAmount'            => $totalAmt - $salesAmt,
				'salesAmount' 		   => $salesAmt,
				'zeroTaxSalesAmount'   => $zeroAmt,
				'freeTaxSalesAmount'   => $freeAmt,
				'totalAmount'          => $totalAmt,
				'mem'         		   => "",
				'customsClearanceMark' => $customsClearanceMark,
				'zeroTaxRateReason'    => $zeroTaxRateReason,
				'productItems'         => $productItems,
				'Token'          	   => $token,
			);
		}else{
			//B2C
			if ( $this->TestMode ) {
				$url = 'https://testinv.sunpay.com.tw/api/v1/SunPay/CreateInvoiceb2c'; // 測試網址
			} else {
				$url = 'https://einv.sunpay.com.tw/api/v1/SunPay/CreateInvoiceb2c'; // 正式網址
			}
			$post_data_array = array( // post_data欄位資料
				'merchantID'           => $MerchantID,
				'orderNo'              => $tradeNo,
				'buyerIdentifier'      => "",
				'buyerName'            => $buyerName,
				'buyerEmailAddress'    => $buyerEmail,
				'isSendMessage'        => $this->IsSendMessage,
				'buyerTelephoneNumber' => $buyerPhone,
				'isSendPaper'          => $IsSendPaper,
				'buyerAddress'         => $buyerAddress,
				'invoiceType'          => $invoiceType,
				'donateMark'     	   => $donateMark ?? 0,
				'poban'       		   => $poban,
				'carrierType'      	   => $carrierType,
				'carrierId1'           => $carrierId1,
				'taxType'              => $taxType,
				'taxRate'        	   => $taxRate,
				'taxAmount'            => $totalAmt - $salesAmt,
				'salesAmount' 		   => $salesAmt,
				'zeroTaxSalesAmount'   => $zeroAmt,
				'freeTaxSalesAmount'   => $freeAmt,
				'totalAmount'          => $totalAmt,
				'mem'         		   => "",
				'customsClearanceMark' => $customsClearanceMark,
				'zeroTaxRateReason'    => $zeroTaxRateReason,
				'isprint'         	   => $IsSendPaper,
				'productItems'         => $productItems,
				'token'          	   => $token,
			);
		}

		$post_data_json              = json_encode($post_data_array); 
		
		$rtn_data = array(
			"url" => $url,
			"post_data_json" => $post_data_json
		);

		return $rtn_data;
	}


	private function chkOrderEiTypeisValid( $order, $eiType ) {
		if ( ! isset( $order ) ) {
			return false;
		}
		if ( ! isset( $eiType ) ) {
			return false;
		}
		return true;
	}

	/**
	 * 取得訂單總金額
	 *
	 * @access public
	 * @param product $product , string $category
	 * @return float|boolean
	 */
    private function getTotalAmount($products)
    {
        $totalPrice = 0;
        foreach ($products as $_ind => $product) {
            if (($_ind + 1) == count($products)) {
                $totalPrice += ceil($product['price']);
                break;
            }
            $totalPrice += ceil($product['price']);
        }

        return $totalPrice;
    }

    private function writeLog($msg = '', $with_input = true)
    {
        $file_path = DIR_LOGS; // 檔案路徑
        if (!is_dir($file_path)) {
            return;
        }

        $file_name = 'sunpay_' . date('Ymd', time()) . '.txt';  // 取時間做檔名 (YYYYMMDD)
        $file = $file_path . $file_name;
        $fp = fopen($file, 'a');
        $input = ($with_input) ? '|REQUEST:' . json_encode($_REQUEST) : '';
        $log_str = date('Y-m-d h:i:s') . '|' . $msg . $input . "\n\n";
        fwrite($fp, $log_str);
        fclose($fp);
        $this->clean_old_log($file_path);
    }

    private function clean_old_log($dir)
    {
        $del_date = date('Ymd', strtotime('-30 day'));
        $scan_dir = glob($dir . 'sunpay_*.txt');
        foreach ($scan_dir as $value) {
            $date = explode('_', basename($value, '.txt'));
            if (strtotime($del_date) > strtotime($date[1])) {
                unlink($value);
            }
        }
    }

}
